package org.findmykids.geo.data.db.dao

import androidx.room.*
import org.findmykids.geo.data.db.model.ErrorEntity


@Dao
internal interface ErrorsDao {
    @Query("SELECT COUNT(id) FROM ErrorEntity")
    fun getRowCount(): Int

    @Query("SELECT * FROM ErrorEntity WHERE sessionIndex = :sessionIndex AND :nowTime - sessionCreate < 60000")
    fun selectOnline(sessionIndex: Long, nowTime: Long): List<ErrorEntity>

    @Query("SELECT * FROM ErrorEntity LIMIT :limit")
    fun select(limit: Int): List<ErrorEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(errorEntity: ErrorEntity)

    @Delete
    fun delete(errorEntity: ErrorEntity)

    @Query("DELETE FROM ErrorEntity")
    fun deleteAll()
}