package org.findmykids.geo.common.di.session.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.common.di.session.SessionScope
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.domain.authorization.AuthorizationInteractor
import org.findmykids.geo.domain.live.error.ErrorInteractor
import org.findmykids.geo.domain.live.location.LocationInteractor
import org.findmykids.geo.domain.live.locator.LocatorInteractor
import org.findmykids.geo.domain.live.remote.RemoteInteractor
import org.findmykids.geo.domain.live.timeout.TimeoutInteractor
import org.findmykids.geo.domain.session.SessionInteractor
import org.findmykids.geo.domain.subscriber.activity.ActivitySubscriberInteractor
import org.findmykids.geo.domain.subscriber.passive.PassiveSubscriberInteractor
import org.findmykids.geo.domain.subscriber.station.StationSubscriberInteractor
import org.findmykids.geo.domain.subscriber.timer.TimerSubscriberInteractor
import org.findmykids.geo.domain.subscriber.zones.ZonesSubscriberInteractor
import org.findmykids.geo.presentation.session.StartedJobs
import org.findmykids.geo.presentation.session.input.CommandFrontController
import org.findmykids.geo.presentation.session.input.CommandFrontControllerImpl
import org.findmykids.geo.presentation.session.live.LiveFacade
import org.findmykids.geo.presentation.session.live.LiveFacadeImpl
import org.findmykids.geo.presentation.session.output.EventFrontController
import org.findmykids.geo.presentation.session.output.EventFrontControllerImpl


@Module(includes = [DomainModule::class])
internal class PresentationModule {
    init {
        Logger.d().print()
    }


    @Provides
    @SessionScope
    fun provideCommandFrontController(
        authorizationInteractor: AuthorizationInteractor,
        sessionInteractor: SessionInteractor,
        timerSubscriberInteractor: TimerSubscriberInteractor,
        passiveSubscriberInteractor: PassiveSubscriberInteractor,
        zonesSubscriberInteractor: ZonesSubscriberInteractor,
        activitySubscriberInteractor: ActivitySubscriberInteractor,
        stationSubscriberInteractor: StationSubscriberInteractor
    ): CommandFrontController = CommandFrontControllerImpl(
        authorizationInteractor,
        sessionInteractor,
        timerSubscriberInteractor,
        passiveSubscriberInteractor,
        zonesSubscriberInteractor,
        activitySubscriberInteractor,
        stationSubscriberInteractor
    )

    @Provides
    @SessionScope
    fun provideLiveFacade(
        remoteInteractor: RemoteInteractor,
        fusedGeoInteractor: LocationInteractor,
        locatorInteractor: LocatorInteractor,
        timeoutInteractor: TimeoutInteractor,
        errorInteractor: ErrorInteractor
    ): LiveFacade = LiveFacadeImpl(
        remoteInteractor,
        fusedGeoInteractor,
        locatorInteractor,
        timeoutInteractor,
        errorInteractor
    )

    @Provides
    @SessionScope
    fun provideEventFrontController(
        authorizationInteractor: AuthorizationInteractor,
        timerSubscriberInteractor: TimerSubscriberInteractor,
        passiveSubscriberInteractor: PassiveSubscriberInteractor,
        zonesSubscriberInteractor: ZonesSubscriberInteractor,
        activitySubscriberInteractor: ActivitySubscriberInteractor,
        stationSubscriberInteractor: StationSubscriberInteractor
    ): EventFrontController = EventFrontControllerImpl(
        authorizationInteractor,
        timerSubscriberInteractor,
        passiveSubscriberInteractor,
        zonesSubscriberInteractor,
        activitySubscriberInteractor,
        stationSubscriberInteractor
    )

    @Provides
    @SessionScope
    fun provideStartedJobs(): StartedJobs = StartedJobs()
}