package org.findmykids.geo.common.di.session

import dagger.Subcomponent
import org.findmykids.geo.common.di.session.module.*
import org.findmykids.geo.data.repository.live.activity.google.ActivityGoogleReceiver
import org.findmykids.geo.data.repository.live.activity.huawei.ActivityHuaweiReceiver
import org.findmykids.geo.data.repository.trigger.activity.ActivityJobSchedulerService
import org.findmykids.geo.data.repository.trigger.boot.BootJobSchedulerService
import org.findmykids.geo.data.repository.trigger.passive.PassiveJobSchedulerService
import org.findmykids.geo.data.repository.trigger.station.StationJobSchedulerService
import org.findmykids.geo.data.repository.trigger.timer.alarm.AlarmJobSchedulerService
import org.findmykids.geo.data.repository.trigger.zones.ZonesJobSchedulerService
import org.findmykids.geo.presentation.session.SessionService


@SessionScope
@Subcomponent(
    modules = [DBModule::class, NetworkModule::class, DataStorageModule::class, DataLiveModule::class, DataTriggerModule::class, DomainModule::class, PresentationModule::class]
)
internal interface SessionComponent {
    fun inject(sessionService: SessionService)

    fun inject(activityJobSchedulerService: ActivityJobSchedulerService)
    fun inject(bootJobSchedulerService: BootJobSchedulerService)
    fun inject(passiveJobSchedulerService: PassiveJobSchedulerService)
    fun inject(stationJobSchedulerService: StationJobSchedulerService)
    fun inject(alarmJobSchedulerService: AlarmJobSchedulerService)
    fun inject(zonesJobSchedulerService: ZonesJobSchedulerService)

    fun inject(activityGoogleReceiver: ActivityGoogleReceiver)
    fun inject(activityHuaweiReceiver: ActivityHuaweiReceiver)

    @Subcomponent.Builder
    interface Builder {
        fun dBModule(dBModule: DBModule): Builder
        fun build(): SessionComponent
    }
}