package org.findmykids.geo.common.di.platform.module

import dagger.Module
import dagger.Provides
import org.findmykids.geo.api.extensions.GeoExtensions
import org.findmykids.geo.api.extensions.SessionExtensions
import org.findmykids.geo.common.di.platform.PlatformScope
import org.findmykids.geo.common.logger.Logger


@Module
internal class ExtensionsModule(
    private val mGeoExtensions: GeoExtensions,
    private val mSessionExtensions: SessionExtensions,
    private val mAppVersion: String
) {
    init {
        Logger.d().print()
    }


    @Provides
    @PlatformScope
    fun provideGeoExtension() = mGeoExtensions

    @Provides
    @PlatformScope
    fun provideSessionExtension() = mSessionExtensions

    @Provides
    @PlatformScope
    fun provideAppVersion() = mAppVersion
}