package org.findmykids.geo.common.di.platform

import dagger.Subcomponent
import org.findmykids.geo.common.di.platform.module.ExtensionsModule
import org.findmykids.geo.common.di.session.SessionComponent


@PlatformScope
@Subcomponent(
    modules = [ExtensionsModule::class]
)
internal interface PlatformComponent {
    fun sessionComponentBuilder(): SessionComponent.Builder

    @Subcomponent.Builder
    interface Builder {
        fun extensionsModule(extensionsModule: ExtensionsModule): Builder
        fun build(): PlatformComponent
    }
}