package org.findmykids.geo.api.model


/**
 * Состояние геоплатформы
 */
sealed class GeoPlatformState(internal val value: Int) {
    object ACTIVATED:GeoPlatformState(1) // Активирована
    object DEACTIVATED:GeoPlatformState(2) // Деактивирована
    object ACTIVATED_TO_ANOTHER_URL:GeoPlatformState(3) // Активирована но на другой url
    object ACTIVATED_TO_ANOTHER_USER_ID:GeoPlatformState(4) // Активирована но для другого user id
    class ERROR(val additionalError: Exception? = null):GeoPlatformState(5) // Не удалось получить ответ


    companion object {
        internal fun getState(value: Int): GeoPlatformState {
          return when(value){
              1 -> ACTIVATED
              2 -> DEACTIVATED
              3-> ACTIVATED_TO_ANOTHER_URL
              4 -> ACTIVATED_TO_ANOTHER_USER_ID
              else -> ERROR()
          }
        }
    }
}