/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.presentation.session;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import androidx.core.content.ContextCompat;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.ReplaySubject;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.R;
import org.findmykids.geo.api.extensions.SessionExtensions;
import org.findmykids.geo.common.di.DIScopeHolder;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.NotificationUtil;
import org.findmykids.geo.domain.factory.CommandFactory;
import org.findmykids.geo.domain.model.Command;
import org.findmykids.geo.domain.model.InnerEvent;
import org.findmykids.geo.presentation.session.SessionService;
import org.findmykids.geo.presentation.session.StartedJobs;
import org.findmykids.geo.presentation.session.input.CommandFrontController;
import org.findmykids.geo.presentation.session.live.LiveFacade;
import org.findmykids.geo.presentation.session.output.EventFrontController;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 :2\u00020\u0001:\u0001:B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010,\u001a\u00020-H\u0002J\u0014\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\b\u00102\u001a\u00020-H\u0016J\b\u00103\u001a\u00020-H\u0016J \u00104\u001a\u00020\u001c2\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0016J\b\u00107\u001a\u00020-H\u0003J\b\u00108\u001a\u000209H\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00128\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020$8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0018\u00010*R\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/findmykids/geo/presentation/session/SessionService;", "Landroid/app/Service;", "()V", "mCommandFrontController", "Lorg/findmykids/geo/presentation/session/input/CommandFrontController;", "getMCommandFrontController", "()Lorg/findmykids/geo/presentation/session/input/CommandFrontController;", "setMCommandFrontController", "(Lorg/findmykids/geo/presentation/session/input/CommandFrontController;)V", "mEventFrontController", "Lorg/findmykids/geo/presentation/session/output/EventFrontController;", "getMEventFrontController", "()Lorg/findmykids/geo/presentation/session/output/EventFrontController;", "setMEventFrontController", "(Lorg/findmykids/geo/presentation/session/output/EventFrontController;)V", "mKillProcess", "Lio/reactivex/disposables/Disposable;", "mLiveFacade", "Lorg/findmykids/geo/presentation/session/live/LiveFacade;", "getMLiveFacade", "()Lorg/findmykids/geo/presentation/session/live/LiveFacade;", "setMLiveFacade", "(Lorg/findmykids/geo/presentation/session/live/LiveFacade;)V", "mQueue", "Lio/reactivex/subjects/ReplaySubject;", "Lorg/findmykids/geo/domain/model/Command;", "mQueueDisposable", "mQueueSize", "", "mSessionExtensions", "Lorg/findmykids/geo/api/extensions/SessionExtensions;", "getMSessionExtensions", "()Lorg/findmykids/geo/api/extensions/SessionExtensions;", "setMSessionExtensions", "(Lorg/findmykids/geo/api/extensions/SessionExtensions;)V", "mStartedJobs", "Lorg/findmykids/geo/presentation/session/StartedJobs;", "getMStartedJobs", "()Lorg/findmykids/geo/presentation/session/StartedJobs;", "setMStartedJobs", "(Lorg/findmykids/geo/presentation/session/StartedJobs;)V", "mWakeLock", "Landroid/os/PowerManager$WakeLock;", "Landroid/os/PowerManager;", "initQueue", "", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "flags", "startId", "setWakelock", "toString", "", "Companion", "geo_release"})
public final class SessionService
extends Service {
    @Inject
    @NotNull
    public CommandFrontController mCommandFrontController;
    @Inject
    @NotNull
    public LiveFacade mLiveFacade;
    @Inject
    @NotNull
    public EventFrontController mEventFrontController;
    @Inject
    @NotNull
    public SessionExtensions mSessionExtensions;
    @Inject
    @NotNull
    public StartedJobs mStartedJobs;
    private volatile PowerManager.WakeLock mWakeLock;
    private Disposable mQueueDisposable;
    private volatile int mQueueSize;
    private final ReplaySubject<Command> mQueue;
    private Disposable mKillProcess;
    private static final int MAX_QUEUE_SIZE = 5;
    private static final int NOTIFICATION_ID = 425211;
    @NotNull
    public static final String ACTION_GEO = "org.findmykids.geo.ACTION_GEO";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CommandFrontController getMCommandFrontController() {
        CommandFrontController commandFrontController = this.mCommandFrontController;
        if (commandFrontController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mCommandFrontController");
        }
        return commandFrontController;
    }

    public final void setMCommandFrontController(@NotNull CommandFrontController commandFrontController) {
        Intrinsics.checkParameterIsNotNull((Object)commandFrontController, (String)"<set-?>");
        this.mCommandFrontController = commandFrontController;
    }

    @NotNull
    public final LiveFacade getMLiveFacade() {
        LiveFacade liveFacade = this.mLiveFacade;
        if (liveFacade == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mLiveFacade");
        }
        return liveFacade;
    }

    public final void setMLiveFacade(@NotNull LiveFacade liveFacade) {
        Intrinsics.checkParameterIsNotNull((Object)liveFacade, (String)"<set-?>");
        this.mLiveFacade = liveFacade;
    }

    @NotNull
    public final EventFrontController getMEventFrontController() {
        EventFrontController eventFrontController = this.mEventFrontController;
        if (eventFrontController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mEventFrontController");
        }
        return eventFrontController;
    }

    public final void setMEventFrontController(@NotNull EventFrontController eventFrontController) {
        Intrinsics.checkParameterIsNotNull((Object)eventFrontController, (String)"<set-?>");
        this.mEventFrontController = eventFrontController;
    }

    @NotNull
    public final SessionExtensions getMSessionExtensions() {
        SessionExtensions sessionExtensions = this.mSessionExtensions;
        if (sessionExtensions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSessionExtensions");
        }
        return sessionExtensions;
    }

    public final void setMSessionExtensions(@NotNull SessionExtensions sessionExtensions) {
        Intrinsics.checkParameterIsNotNull((Object)sessionExtensions, (String)"<set-?>");
        this.mSessionExtensions = sessionExtensions;
    }

    @NotNull
    public final StartedJobs getMStartedJobs() {
        StartedJobs startedJobs = this.mStartedJobs;
        if (startedJobs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartedJobs");
        }
        return startedJobs;
    }

    public final void setMStartedJobs(@NotNull StartedJobs startedJobs) {
        Intrinsics.checkParameterIsNotNull((Object)startedJobs, (String)"<set-?>");
        this.mStartedJobs = startedJobs;
    }

    @NotNull
    public String toString() {
        return "";
    }

    public void onCreate() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        super.onCreate();
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        Context context = this.getBaseContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"baseContext");
        PackageManager packageManager = context.getPackageManager();
        Context context2 = this.getBaseContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"baseContext");
        Bundle bundle = packageManager.getApplicationInfo((String)context2.getPackageName(), (int)128).metaData;
        String title = bundle.getString(this.getBaseContext().getString(R.string.geo_notification_title));
        String description = bundle.getString(this.getBaseContext().getString(R.string.geo_notification_description));
        int icon = bundle.getInt(this.getBaseContext().getString(R.string.geo_notification_icon));
        if (title == null || description == null || icon == 0) {
            throw (Throwable)new RuntimeException("Notification metadata not found in manifest");
        }
        this.startForeground(425211, NotificationUtil.INSTANCE.create((Context)this, title, description, icon));
        DIScopeHolder.INSTANCE.createSessionScope().inject(this);
        Disposable disposable = this.mKillProcess;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mKillProcess = null;
        if (this.mWakeLock == null) {
            this.setWakelock();
        }
    }

    public void onDestroy() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        super.onDestroy();
        Disposable disposable = this.mQueueDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mQueueDisposable = null;
        DIScopeHolder.INSTANCE.clearSessionScope();
        StartedJobs startedJobs = this.mStartedJobs;
        if (startedJobs == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStartedJobs");
        }
        startedJobs.stopJobs();
        this.mKillProcess = Completable.timer((long)10L, (TimeUnit)TimeUnit.SECONDS).subscribe((Action)onDestroy.1.INSTANCE);
        if (this.mWakeLock != null) {
            PowerManager.WakeLock wakeLock = this.mWakeLock;
            if (wakeLock == null) {
                Intrinsics.throwNpe();
            }
            if (wakeLock.isHeld()) {
                PowerManager.WakeLock wakeLock2 = this.mWakeLock;
                if (wakeLock2 == null) {
                    Intrinsics.throwNpe();
                }
                wakeLock2.release();
            }
        }
        this.mWakeLock = null;
        this.stopForeground(true);
    }

    public int onStartCommand(@NotNull Intent intent, int flags, int startId) {
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        if (this.mWakeLock == null) {
            this.setWakelock();
        }
        if (this.mQueueDisposable == null) {
            this.initQueue();
        }
        this.mQueue.onNext((Object)CommandFactory.INSTANCE.createInnerCommand(intent));
        return 3;
    }

    @Nullable
    public IBinder onBind(@Nullable Intent intent) {
        return null;
    }

    @SuppressLint(value={"WakelockTimeout"})
    private final void setWakelock() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        try {
            Object object = ContextCompat.getSystemService((Context)((Context)this), PowerManager.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            PowerManager.WakeLock wakeLock = this.mWakeLock = ((PowerManager)object).newWakeLock(1, SessionService.class.getSimpleName());
            if (wakeLock == null) {
                Intrinsics.throwNpe();
            }
            if (!wakeLock.isHeld()) {
                PowerManager.WakeLock wakeLock2 = this.mWakeLock;
                if (wakeLock2 == null) {
                    Intrinsics.throwNpe();
                }
                wakeLock2.acquire();
            }
        }
        catch (Exception e) {
            Logger.INSTANCE.e(e).print();
            this.mWakeLock = null;
        }
    }

    private final void initQueue() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        SessionExtensions sessionExtensions = this.mSessionExtensions;
        if (sessionExtensions == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mSessionExtensions");
        }
        sessionExtensions.onSessionBegin();
        this.mQueueDisposable = this.mQueue.doOnNext((Consumer)new Consumer<Command>(this){
            final /* synthetic */ SessionService this$0;

            public final void accept(Command command) {
                Logger.INSTANCE.d("doOnNext").addArg(command).with((Object)((Object)this.this$0)).print();
                if (command.isMain()) {
                    SessionService sessionService = this.this$0;
                    int n = SessionService.access$getMQueueSize$p(sessionService);
                    SessionService.access$setMQueueSize$p(sessionService, n + 1);
                }
                SessionExtensions sessionExtensions = this.this$0.getMSessionExtensions();
                Command command2 = command;
                Intrinsics.checkExpressionValueIsNotNull((Object)command2, (String)"command");
                sessionExtensions.onNewCommand(command2);
            }
            {
                this.this$0 = sessionService;
            }
        }).subscribeOn(AndroidSchedulers.mainThread()).observeOn(Schedulers.single()).concatMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ SessionService this$0;

            public final Observable<Boolean> apply(@NotNull Command command) {
                Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
                Logger.INSTANCE.d("concatMap").addArg(command).with((Object)((Object)this.this$0)).print();
                return this.this$0.getMCommandFrontController().add(command).map((Function)new Function<T, R>(this, command){
                    final /* synthetic */ initQueue.2 this$0;
                    final /* synthetic */ Command $command;

                    /*
                     * WARNING - void declaration
                     */
                    public final boolean apply(@NotNull Pair<Boolean, Integer> $dstr$isActivateLive$left) {
                        void isActivateLive;
                        Intrinsics.checkParameterIsNotNull($dstr$isActivateLive$left, (String)"<name for destructuring parameter 0>");
                        boolean bl = (Boolean)$dstr$isActivateLive$left.component1();
                        int left = ((Number)$dstr$isActivateLive$left.component2()).intValue();
                        Logger.INSTANCE.d("map").addArg((boolean)isActivateLive).addArg(left).with((Object)((Object)this.this$0.this$0)).print();
                        if (left == 0 && this.$command.isMain()) {
                            SessionService sessionService = this.this$0.this$0;
                            int n = SessionService.access$getMQueueSize$p(sessionService);
                            SessionService.access$setMQueueSize$p(sessionService, n + -1);
                        }
                        return (boolean)isActivateLive;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$command = command;
                    }
                });
            }
            {
                this.this$0 = sessionService;
            }
        }).distinctUntilChanged().switchMap(new Function<T, ObservableSource<? extends R>>(this){
            final /* synthetic */ SessionService this$0;

            @NotNull
            public final Observable<InnerEvent> apply(@NotNull Boolean isActivateLive) {
                Intrinsics.checkParameterIsNotNull((Object)isActivateLive, (String)"isActivateLive");
                Logger.INSTANCE.d("switchMap").addArg(isActivateLive).with((Object)((Object)this.this$0)).print();
                return isActivateLive != false ? this.this$0.getMLiveFacade().start() : this.this$0.getMLiveFacade().stop();
            }
            {
                this.this$0 = sessionService;
            }
        }).concatMapSingle(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ SessionService this$0;

            @NotNull
            public final Single<Boolean> apply(@NotNull InnerEvent innerEvent) {
                Intrinsics.checkParameterIsNotNull((Object)innerEvent, (String)"innerEvent");
                Logger.INSTANCE.d("concatMapSingle").addArg(innerEvent).with((Object)((Object)this.this$0)).print();
                return this.this$0.getMEventFrontController().isNeedStopService(innerEvent);
            }
            {
                this.this$0 = sessionService;
            }
        }).takeUntil((Predicate)new Predicate<Boolean>(this){
            final /* synthetic */ SessionService this$0;

            public final boolean test(@NotNull Boolean isNeedStopService2) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)isNeedStopService2, (String)"isNeedStopService");
                Logger.INSTANCE.d("takeUntil").addArg(isNeedStopService2).addArg(SessionService.access$getMQueueSize$p(this.this$0)).with((Object)((Object)this.this$0)).print();
                if (isNeedStopService2.booleanValue() && (SessionService.access$getMQueueSize$p(this.this$0) == 0 || SessionService.access$getMQueueSize$p(this.this$0) > 5)) {
                    Logger.INSTANCE.d("Stop").with((Object)((Object)this.this$0)).print();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = sessionService;
            }
        }).subscribeOn(Schedulers.single()).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ SessionService this$0;

            public final void accept(Boolean it) {
                Logger.INSTANCE.d("onNext").with((Object)((Object)this.this$0)).print();
            }
            {
                this.this$0 = sessionService;
            }
        }, (Consumer)new Consumer<Throwable>(this){
            final /* synthetic */ SessionService this$0;

            public final void accept(Throwable throwable) {
                Throwable throwable2 = throwable;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"throwable");
                Logger.INSTANCE.e(throwable2).with((Object)((Object)this.this$0)).print();
                this.this$0.stopSelf();
            }
            {
                this.this$0 = sessionService;
            }
        }, new Action(this){
            final /* synthetic */ SessionService this$0;

            public final void run() {
                Logger.INSTANCE.i("onComplete").with((Object)((Object)this.this$0)).print();
                this.this$0.getMSessionExtensions().onSessionEnd();
                this.this$0.stopSelf();
            }
            {
                this.this$0 = sessionService;
            }
        });
    }

    public SessionService() {
        ReplaySubject replaySubject = ReplaySubject.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)replaySubject, (String)"ReplaySubject.create()");
        this.mQueue = replaySubject;
    }

    public static final /* synthetic */ int access$getMQueueSize$p(SessionService $this) {
        return $this.mQueueSize;
    }

    public static final /* synthetic */ void access$setMQueueSize$p(SessionService $this, int n) {
        $this.mQueueSize = n;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/findmykids/geo/presentation/session/SessionService$Companion;", "", "()V", "ACTION_GEO", "", "MAX_QUEUE_SIZE", "", "NOTIFICATION_ID", "geo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

