package org.findmykids.geo.domain.subscriber.passive

import io.reactivex.Completable
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository
import org.findmykids.geo.data.repository.trigger.passive.PassiveManager
import javax.inject.Inject


internal class PassiveSubscriberInteractorImpl @Inject constructor(
    private val mPassiveLocationManagerManager: PassiveManager,
    private val mPassiveGoogleFusedManager: PassiveManager,
    private val mPassiveHuaweiFusedManager: PassiveManager,
    private val mConfigurationRepository: ConfigurationRepository
) : PassiveSubscriberInteractor {

    override fun toString(): String = ""

    override fun subscribe(): Completable = mPassiveLocationManagerManager
        .unsubscribe()
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mPassiveLocationManagerManager.subscribe(it.passiveConfiguration) }
        .andThen(mPassiveGoogleFusedManager.unsubscribe())
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mPassiveGoogleFusedManager.subscribe(it.passiveConfiguration) }
        .andThen(mPassiveHuaweiFusedManager.unsubscribe())
        .andThen(mConfigurationRepository.get())
        .flatMapCompletable { mPassiveHuaweiFusedManager.subscribe(it.passiveConfiguration) }

    override fun unsubscribe(): Completable = mPassiveLocationManagerManager
        .unsubscribe()
        .andThen(mPassiveGoogleFusedManager.unsubscribe())
        .andThen(mPassiveHuaweiFusedManager.unsubscribe())

    override fun subscribeIfNeed(): Completable = mPassiveLocationManagerManager
        .isSubscribed()
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mPassiveLocationManagerManager.subscribe(it.passiveConfiguration) }
            }
        }
        .andThen(mPassiveGoogleFusedManager.isSubscribed())
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mPassiveGoogleFusedManager.subscribe(it.passiveConfiguration) }
            }
        }
        .andThen(mPassiveHuaweiFusedManager.isSubscribed())
        .flatMapCompletable { isSubscribed ->
            if (isSubscribed) {
                Completable.complete()
            } else {
                mConfigurationRepository
                    .get()
                    .flatMapCompletable { mPassiveHuaweiFusedManager.subscribe(it.passiveConfiguration) }
            }
        }
}