package org.findmykids.geo.domain.authorization

import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.Container


/**
 * Логика активации
 */
internal interface AuthorizationInteractor {
    /**
     * Активация
     */
    fun activate(baseUrl: String, apiKey: CharArray, userToken: CharArray, userId: CharArray): Completable

    /**
     * Деактивация
     */
    fun deactivate(): Completable

    /**
     * Активировано ли гео
     */
    fun isActivated(): Single<Boolean>

    /**
     * Url на который подключается гео
     */
    fun getBaseUrl(): Single<Container<String>>

    /**
     * id пользователя
     */
    fun getUserId(): Single<Container<CharArray>>
}