package org.findmykids.geo.data.repository.storage.request

import io.reactivex.Completable
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.network.SocketClient
import org.findmykids.geo.data.network.model.SocketCommand
import org.findmykids.geo.data.network.model.SocketData
import javax.inject.Inject


internal class RequestRepositoryImpl @Inject constructor(
    private val mSocketClient: SocketClient
) : RequestRepository {

    override fun toString(): String = ""

    override fun sendNoGeo(): Completable = Completable
        .fromCallable {
            Logger.d().with(this@RequestRepositoryImpl).print()
        }
        .andThen(
            mSocketClient
                .send(
                    SocketData(
                        commandId = SocketCommand.COORD_EMPTY
                    )
                )
        )
        .ignoreElement()
        .doOnComplete {
            Logger.d("Complete").with(this@RequestRepositoryImpl).print()
        }

    override fun sendGeoNotChanged(): Completable = Completable
        .fromCallable {
            Logger.d().with(this@RequestRepositoryImpl).print()
        }
        .andThen(
            mSocketClient
                .send(
                    SocketData(
                        commandId = SocketCommand.COORD_NOT_CHANGED
                    )
                )
        )
        .ignoreElement()
        .doOnComplete {
            Logger.d("Complete").with(this@RequestRepositoryImpl).print()
        }
}