package org.findmykids.geo.data.model


internal data class Configurations(
    val activityConfiguration: Configuration.ActivityConfiguration,
    val timerConfiguration: Configuration.TimerConfiguration,
    val passiveConfiguration: Configuration.PassiveConfiguration,
    val stationConfiguration: Configuration.StationConfiguration,

    val locationDataConfiguration: Configuration.LocationDataConfiguration,
    val gpsDataConfiguration: Configuration.GpsDataConfiguration,
    val lbsDataConfiguration: Configuration.LbsDataConfiguration,
    val wifiDataConfiguration: Configuration.WifiDataConfiguration,
    val sensorsDataConfiguration: Configuration.SensorsDataConfiguration,
    val socketDataConfiguration: Configuration.RemoteDataConfiguration,
    val timeoutDataConfiguration: Configuration.TimeoutDataConfiguration,
    val activityDataConfiguration: Configuration.ActivityDataConfiguration,
    val batteryDataConfiguration: Configuration.BatteryDataConfiguration,

    val locationLiveConfiguration: Configuration.LocationLiveConfiguration,
    val locatorLiveConfiguration: Configuration.LocatorLiveConfiguration,

    val geoStorageConfiguration: Configuration.GeoStorageConfiguration,
    val errorStorageConfiguration: Configuration.ErrorStorageConfiguration
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[0].name}=$activityConfiguration, " +
                "${this::class.java.declaredFields[14].name}=$timerConfiguration, " +
                "${this::class.java.declaredFields[10].name}=$passiveConfiguration, " +
                "${this::class.java.declaredFields[13].name}=$stationConfiguration, " +
                "${this::class.java.declaredFields[7].name}=$locationDataConfiguration, " +
                "${this::class.java.declaredFields[5].name}=$gpsDataConfiguration, " +
                "${this::class.java.declaredFields[6].name}=$lbsDataConfiguration, " +
                "${this::class.java.declaredFields[16].name}=$wifiDataConfiguration, " +
                "${this::class.java.declaredFields[11].name}=$sensorsDataConfiguration, " +
                "${this::class.java.declaredFields[12].name}=$socketDataConfiguration, " +
                "${this::class.java.declaredFields[15].name}=$timeoutDataConfiguration, " +
                "${this::class.java.declaredFields[1].name}=$activityDataConfiguration, " +
                "${this::class.java.declaredFields[2].name}=$batteryDataConfiguration, " +
                "${this::class.java.declaredFields[8].name}=$locationLiveConfiguration, " +
                "${this::class.java.declaredFields[9].name}=$locatorLiveConfiguration, " +
                "${this::class.java.declaredFields[4].name}=$geoStorageConfiguration, " +
                "${this::class.java.declaredFields[3].name}=$errorStorageConfiguration)"}
}