package org.findmykids.geo.data.db.dao

import androidx.room.*
import org.findmykids.geo.data.db.model.ConfigurationEntity


@Dao
internal interface ConfigurationsDao {
    @Query("SELECT * FROM ConfigurationEntity")
    fun selectAll(): List<ConfigurationEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(configurationEntity: ConfigurationEntity)

    @Query("DELETE FROM ConfigurationEntity")
    fun deleteAll()
}