package org.findmykids.geo.api.model


/**
 * Состояние геоплатформы
 */
enum class GeoPlatformState(internal val value: Int) {
    ACTIVATED(1), // Активирована
    DEACTIVATED(2), // Деактивирована
    ACTIVATED_TO_ANOTHER_URL(3), // Активирована но на другой url
    ACTIVATED_TO_ANOTHER_USER_ID(4), // Активирована но для другого user id
    ERROR(5); // Не удалось получить ответ


    companion object {
        internal fun getState(value: Int): GeoPlatformState = values().firstOrNull { it.value == value } ?: ERROR
    }
}