package org.findmykids.geo.api

import android.annotation.SuppressLint
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.database.Cursor
import android.net.Uri
import android.os.Build
import org.findmykids.geo._todo.GeoConverter
import org.findmykids.geo.api.listeners.GeoListener
import org.findmykids.geo.api.model.GeoPlatformState
import org.findmykids.geo.data.repository.trigger.task.Tasks
import org.findmykids.geo.presentation.manage.AuthorityCheckProvider
import org.findmykids.geo.presentation.session.SessionService


/**
 * Основной класс для управления гео платформы
 * Общение происходит через startService, startForegroundService и WorkManager в зависимости от условий
 */
object GeoPlatform {

    /**
     * Узнать состояние гео платформы
     */
    @SuppressLint("Recycle")
    @JvmStatic
    @Synchronized
    fun isActivatedTo(context: Context, baseUrl: String, userId: CharArray): GeoPlatformState {
        var i = 0
        var result = GeoPlatformState.ERROR
        var cursor: Cursor? = null
        do {
            i++
            try {
                cursor = context.contentResolver.query(
                    Uri.parse("content://" + GeoPlatformSettings.mAppId + "." + AuthorityCheckProvider.NAME),
                    null,
                    null,
                    arrayOf(baseUrl, String(userId)),
                    null
                )

                if (cursor != null) {
                    result = GeoPlatformState.getState(cursor.getInt(0))
                    i += 3
                }

                ping(context)
                Thread.sleep(200)

            } catch (e: Exception) {
                e.printStackTrace()
            } finally {
                try {
                    cursor?.close()
                } catch (e: Exception) {
                    e.printStackTrace()
                }
            }
        } while (i < 3)

        return result
    }

    /**
     * Активация гео платформы
     */
    @JvmStatic
    fun activate(context: Context, baseUrl: String, apiKey: CharArray, userToken: CharArray, userId: CharArray) {
        startService(
            context,
            getIntent(context, Tasks.ACTIVATE).apply {
                putExtra(Tasks.API_KEY, apiKey)
                putExtra(Tasks.USER_ID, userId)
                putExtra(Tasks.BASE_URL, baseUrl)
                putExtra(Tasks.USER_TOKEN, userToken)
            }
        )
    }

    /**
     * деактивация геоплатформы
     */
    @JvmStatic
    fun deactivate(context: Context) {
        startService(context, getIntent(context, Tasks.DEACTIVATE))
    }


    /**
     * Запустить геопалторму
     */
    @JvmStatic
    fun ping(context: Context) {
        startService(context, getIntent(context, Tasks.PING))
    }


    /**
     * Запрос координаты и посылает ее на сервер. не используется, поэтому может не работать
     */
    @JvmStatic
    fun locationRequest(context: Context) {
        startService(context, getIntent(context, Tasks.REQUEST))
    }

    /**
     * Включить или отключить реалтайм
     */
    @JvmStatic
    fun setRealtime(context: Context, enable: Boolean) {
        startService(
            context,
            getIntent(context, Tasks.REAL_TIME).apply {
                putExtra(Tasks.REAL_TIME_ENABLED, enable)
            }
        )
    }


    private fun getIntent(context: Context, task: Tasks) =
        Intent(context, SessionService::class.java).apply {
            action = task.name
        }

    private fun startService(context: Context, intent: Intent) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            context.startForegroundService(intent)
        } else {
            context.startService(intent)
        }
    }
}