/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.storage.geo;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.data.db.model.SendGeoLocationEntity;
import org.findmykids.geo.data.model.Activity;
import org.findmykids.geo.data.model.ActivityType;
import org.findmykids.geo.data.model.Battery;
import org.findmykids.geo.data.model.CalculatedLocation;
import org.findmykids.geo.data.model.GeoLocation;
import org.findmykids.geo.data.model.GpsInfo;
import org.findmykids.geo.data.model.Location;
import org.findmykids.geo.data.model.SendGeoLocation;
import org.findmykids.geo.data.model.Session;
import org.findmykids.geo.data.model.Wifi;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f\u00a8\u0006\u000e"}, d2={"Lorg/findmykids/geo/data/repository/storage/geo/SendGeoLocationFactory;", "", "()V", "create", "Lorg/findmykids/geo/data/model/SendGeoLocation;", "sendGeoLocationEntity", "Lorg/findmykids/geo/data/db/model/SendGeoLocationEntity;", "geoLocation", "Lorg/findmykids/geo/data/model/GeoLocation;", "sendReason", "", "sendIndex", "", "globalSendIndex", "geo_release"})
public final class SendGeoLocationFactory {
    public static final SendGeoLocationFactory INSTANCE;

    @NotNull
    public final SendGeoLocation create(@NotNull GeoLocation geoLocation, @NotNull String sendReason, long sendIndex, long globalSendIndex) {
        Intrinsics.checkParameterIsNotNull((Object)geoLocation, (String)"geoLocation");
        Intrinsics.checkParameterIsNotNull((Object)sendReason, (String)"sendReason");
        return new SendGeoLocation(geoLocation.getCreate(), geoLocation.getSession(), geoLocation.getLocation(), geoLocation.getLocationDefineSessionIndex(), geoLocation.getLocationDefineGlobalIndex(), geoLocation.getCalculatedLocation(), geoLocation.getGpsInfo(), geoLocation.getActivity(), geoLocation.getBattery(), geoLocation.getWifi(), sendReason, sendIndex, globalSendIndex, MapsKt.toMutableMap(geoLocation.getExtensions()));
    }

    @NotNull
    public final SendGeoLocation create(@NotNull SendGeoLocationEntity sendGeoLocationEntity) {
        Wifi wifi;
        Battery battery;
        Activity activity2;
        GpsInfo gpsInfo;
        CalculatedLocation calculatedLocation;
        Intrinsics.checkParameterIsNotNull((Object)sendGeoLocationEntity, (String)"sendGeoLocationEntity");
        Date date = sendGeoLocationEntity.getCreate();
        Session session = new Session(sendGeoLocationEntity.getSessionIndex(), sendGeoLocationEntity.getSessionCreate(), sendGeoLocationEntity.getSessionIsRealtime(), sendGeoLocationEntity.getSessionCommandsTypes());
        Location location = new Location(sendGeoLocationEntity.getLocationLatitude(), sendGeoLocationEntity.getLocationLongitude(), sendGeoLocationEntity.getLocationProvider(), sendGeoLocationEntity.getLocationTime(), sendGeoLocationEntity.getLocationAltitude(), sendGeoLocationEntity.getLocationAccuracy(), sendGeoLocationEntity.getLocationBearing(), sendGeoLocationEntity.getLocationElapsedRealtimeUncertaintyNanos(), sendGeoLocationEntity.getLocationSpeed(), sendGeoLocationEntity.getLocationSpeedAccuracyMetersPerSecond(), sendGeoLocationEntity.getLocationVerticalAccuracyMeters(), sendGeoLocationEntity.getLocationBearingAccuracyDegrees(), sendGeoLocationEntity.getLocationElapsedRealtimeNanos(), sendGeoLocationEntity.getLocationSource());
        long l = sendGeoLocationEntity.getLocationDefineSessionIndex();
        long l2 = sendGeoLocationEntity.getLocationDefineGlobalIndex();
        if (sendGeoLocationEntity.getCalculatedLocationExist()) {
            Double d = sendGeoLocationEntity.getCalculatedLocationLatitude();
            if (d == null) {
                Intrinsics.throwNpe();
            }
            double d2 = d;
            Double d3 = sendGeoLocationEntity.getCalculatedLocationLongitude();
            if (d3 == null) {
                Intrinsics.throwNpe();
            }
            double d4 = d3;
            Double d5 = sendGeoLocationEntity.getCalculatedLocationAltitude();
            if (d5 == null) {
                Intrinsics.throwNpe();
            }
            double d6 = d5;
            Double d7 = sendGeoLocationEntity.getCalculatedLocationSpeed();
            if (d7 == null) {
                Intrinsics.throwNpe();
            }
            calculatedLocation = new CalculatedLocation(d2, d4, d6, d7);
        } else {
            calculatedLocation = null;
        }
        if (sendGeoLocationEntity.getGpsInfoExist()) {
            Integer n = sendGeoLocationEntity.getGpsInfoTimeToFirstFix();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            int n2 = n;
            Integer n3 = sendGeoLocationEntity.getGpsInfoMaxSatellites();
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            int n4 = n3;
            List<GpsInfo.SatelliteInfo> list = sendGeoLocationEntity.getGpsInfoSatellites();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            gpsInfo = new GpsInfo(n2, n4, list);
        } else {
            gpsInfo = null;
        }
        if (sendGeoLocationEntity.getActivityExist()) {
            Long l3 = sendGeoLocationEntity.getActivityElapsedRealtimeMillis();
            if (l3 == null) {
                Intrinsics.throwNpe();
            }
            long l4 = l3;
            Long l5 = sendGeoLocationEntity.getActivityTime();
            if (l5 == null) {
                Intrinsics.throwNpe();
            }
            long l6 = l5;
            Map<ActivityType, Integer> map = sendGeoLocationEntity.getActivityActivitiesWithConfidences();
            if (map == null) {
                Intrinsics.throwNpe();
            }
            activity2 = new Activity(l4, l6, map);
        } else {
            activity2 = null;
        }
        if (sendGeoLocationEntity.getBatteryExist()) {
            Boolean bl = sendGeoLocationEntity.getBatteryIsCharging();
            if (bl == null) {
                Intrinsics.throwNpe();
            }
            boolean bl2 = bl;
            Integer n = sendGeoLocationEntity.getBatteryLevel();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            battery = new Battery(bl2, n);
        } else {
            battery = null;
        }
        if (sendGeoLocationEntity.getWifiExist()) {
            String string = sendGeoLocationEntity.getWifiSsid();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String string2 = sendGeoLocationEntity.getWifiMac();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Integer n = sendGeoLocationEntity.getWifiLevel();
            if (n == null) {
                Intrinsics.throwNpe();
            }
            wifi = new Wifi(string, string2, n);
        } else {
            wifi = null;
        }
        return new SendGeoLocation(date, session, location, l, l2, calculatedLocation, gpsInfo, activity2, battery, wifi, sendGeoLocationEntity.getSendReason(), sendGeoLocationEntity.getSendSessionIndex(), sendGeoLocationEntity.getSendGlobalIndex(), MapsKt.toMutableMap(sendGeoLocationEntity.getExtensions()));
    }

    private SendGeoLocationFactory() {
    }

    static {
        SendGeoLocationFactory sendGeoLocationFactory;
        INSTANCE = sendGeoLocationFactory = new SendGeoLocationFactory();
    }
}

