/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.core.content.ContextCompat;
import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.Container;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.ManufactureUtil;
import org.findmykids.geo.common.utils.WifiUtil;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.model.Wifi;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.repository.live.wifi.WifiListFactory;
import org.findmykids.geo.data.repository.live.wifi.WifiRepository;
import org.findmykids.geo.data.repository.live.wifi.WifiRepositoryImpl;
import org.findmykids.geo.data.repository.live.wifi.WifisEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000*\u0001\u0015\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u0019H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\fH\u0014J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\u001dH\u0014J\b\u0010$\u001a\u00020\u001dH\u0002J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/findmykids/geo/data/repository/live/wifi/WifiRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/wifi/WifiRepository;", "mContext", "Landroid/content/Context;", "mLocalPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "(Landroid/content/Context;Lorg/findmykids/geo/data/preferences/LocalPreferences;)V", "mConfiguration", "Lorg/findmykids/geo/data/model/Configuration$WifiDataConfiguration;", "mConnectivityManager", "Landroid/net/ConnectivityManager;", "mHandlerThread", "Landroid/os/HandlerThread;", "mIsWifiScanReceiveRegistered", "", "mNextScanDisposable", "Lio/reactivex/disposables/Disposable;", "mRestartDisposable", "mWifiManager", "Landroid/net/wifi/WifiManager;", "mWifiScanReceiver", "org/findmykids/geo/data/repository/live/wifi/WifiRepositoryImpl$mWifiScanReceiver$1", "Lorg/findmykids/geo/data/repository/live/wifi/WifiRepositoryImpl$mWifiScanReceiver$1;", "mWifiStateBeforeStart", "getCurrentWifi", "Lio/reactivex/Single;", "Lorg/findmykids/geo/common/Container;", "Lorg/findmykids/geo/data/model/Wifi;", "restart", "", "configuration", "handlerThread", "scheduledNextScan", "start", "startWifiScan", "stop", "stopWifiScan", "toString", "", "geo_release"})
public final class WifiRepositoryImpl
extends WifiRepository {
    private Disposable mNextScanDisposable;
    private Disposable mRestartDisposable;
    private Configuration.WifiDataConfiguration mConfiguration;
    private HandlerThread mHandlerThread;
    private final WifiManager mWifiManager;
    private final ConnectivityManager mConnectivityManager;
    private boolean mWifiStateBeforeStart;
    private boolean mIsWifiScanReceiveRegistered;
    private final mWifiScanReceiver.1 mWifiScanReceiver;
    private final Context mContext;
    private final LocalPreferences mLocalPreferences;

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    protected void start(@NotNull Configuration.WifiDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        this.mConfiguration = configuration;
        this.mHandlerThread = handlerThread;
        this.scheduledNextScan(configuration, handlerThread);
    }

    @Override
    protected void stop() {
        block1: {
            Logger.i$default(Logger.INSTANCE, null, 1, null).print();
            this.stopWifiScan();
            Disposable disposable = this.mNextScanDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
            Disposable disposable2 = this.mRestartDisposable;
            if (disposable2 == null) break block1;
            disposable2.dispose();
        }
    }

    @Override
    @NotNull
    public Single<Container<Wifi>> getCurrentWifi() {
        Single single = Single.fromCallable((Callable)new Callable<T>(this){
            final /* synthetic */ WifiRepositoryImpl this$0;

            @NotNull
            public final Container<Wifi> call() {
                Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0).print();
                String ssid = WifiUtil.INSTANCE.getCurrentSsid(WifiRepositoryImpl.access$getMConnectivityManager$p(this.this$0), WifiRepositoryImpl.access$getMWifiManager$p(this.this$0));
                String mac = WifiUtil.INSTANCE.getCurrentMac(WifiRepositoryImpl.access$getMWifiManager$p(this.this$0));
                Integer level = WifiUtil.INSTANCE.getCurrentLevel(WifiRepositoryImpl.access$getMWifiManager$p(this.this$0));
                Wifi wifi = ssid != null && mac != null && level != null ? new Wifi(ssid, mac, level) : null;
                return new Container<Wifi>(wifi);
            }
            {
                this.this$0 = wifiRepositoryImpl;
            }
        }).doOnSuccess((Consumer)new Consumer<Container<Wifi>>(this){
            final /* synthetic */ WifiRepositoryImpl this$0;

            public final void accept(Container<Wifi> it) {
                Logger.d$default(Logger.INSTANCE, null, 1, null).setResult(it.getValue()).with(this.this$0).print();
            }
            {
                this.this$0 = wifiRepositoryImpl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single\n        .fromCall\u2026ryImpl).print()\n        }");
        return single;
    }

    private final void startWifiScan(Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mWifiStateBeforeStart = this.mWifiManager.isWifiEnabled();
        if (Build.VERSION.SDK_INT >= 26 && this.mContext.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.CHANGE_WIFI_STATE") != 0) {
            this.sendError(new GeoException.WifiNoPermission("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.CHANGE_WIFI_STATE"));
            this.restart(configuration, handlerThread);
        } else if (Build.VERSION.SDK_INT >= 29 && this.mContext.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_WIFI_STATE") != 0 && this.mContext.checkSelfPermission("android.permission.CHANGE_WIFI_STATE") != 0) {
            this.sendError(new GeoException.WifiNoPermission("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_WIFI_STATE", "android.permission.CHANGE_WIFI_STATE"));
            this.restart(configuration, handlerThread);
        } else {
            boolean isEnabled;
            boolean bl = Build.VERSION.SDK_INT >= 18 && this.mWifiManager.isScanAlwaysAvailable() ? true : (this.mWifiManager.isWifiEnabled() ? true : (isEnabled = ManufactureUtil.INSTANCE.isXiaomiNoGoogleOne() ? false : this.mWifiManager.setWifiEnabled(true)));
            if (isEnabled) {
                this.mLocalPreferences.setLastWifiScanTime(new Date());
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.net.wifi.SCAN_RESULTS");
                this.mIsWifiScanReceiveRegistered = true;
                this.mContext.registerReceiver((BroadcastReceiver)this.mWifiScanReceiver, intentFilter, null, new Handler(handlerThread.getLooper()));
                boolean success = this.mWifiManager.startScan();
                if (!success) {
                    this.sendError(new GeoException.WifiScanFailure());
                    this.stopWifiScan();
                    this.restart(configuration, handlerThread);
                }
            } else {
                this.sendError(new GeoException.WifiNotEnabled());
                this.stopWifiScan();
                this.restart(configuration, handlerThread);
            }
        }
    }

    private final void stopWifiScan() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        if (this.mIsWifiScanReceiveRegistered) {
            this.mIsWifiScanReceiveRegistered = false;
            this.mContext.unregisterReceiver((BroadcastReceiver)this.mWifiScanReceiver);
        }
        if (this.mWifiStateBeforeStart != this.mWifiManager.isWifiEnabled()) {
            this.mWifiManager.setWifiEnabled(this.mWifiStateBeforeStart);
        }
    }

    private final void scheduledNextScan(Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        long minInterval = Build.VERSION.SDK_INT < 26 ? TimeUnit.MINUTES.toMillis(10L) : TimeUnit.MINUTES.toMillis(30L);
        long dif = System.currentTimeMillis() - this.mLocalPreferences.getLastWifiScanTime().getTime();
        long l = 0L;
        long l2 = minInterval - dif;
        boolean bl = false;
        long delay = Math.max(l, l2);
        if (delay == 0L) {
            this.startWifiScan(configuration, handlerThread);
        } else {
            this.mNextScanDisposable = Completable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe(new Action(this, configuration, handlerThread){
                final /* synthetic */ WifiRepositoryImpl this$0;
                final /* synthetic */ Configuration.WifiDataConfiguration $configuration;
                final /* synthetic */ HandlerThread $handlerThread;

                public final void run() {
                    WifiRepositoryImpl.access$setMNextScanDisposable$p(this.this$0, null);
                    Logger.INSTANCE.d("restart").with(this.this$0).print();
                    if (WifiRepositoryImpl.access$isStarted(this.this$0)) {
                        WifiRepositoryImpl.access$startWifiScan(this.this$0, this.$configuration, this.$handlerThread);
                    }
                }
                {
                    this.this$0 = wifiRepositoryImpl;
                    this.$configuration = wifiDataConfiguration;
                    this.$handlerThread = handlerThread;
                }
            }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
                final /* synthetic */ WifiRepositoryImpl this$0;
                final /* synthetic */ Configuration.WifiDataConfiguration $configuration;
                final /* synthetic */ HandlerThread $handlerThread;

                public final void accept(Throwable it) {
                    WifiRepositoryImpl.access$setMNextScanDisposable$p(this.this$0, null);
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    WifiRepositoryImpl.access$sendError(this.this$0, new GeoException.WifiSchedule(throwable));
                    WifiRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
                }
                {
                    this.this$0 = wifiRepositoryImpl;
                    this.$configuration = wifiDataConfiguration;
                    this.$handlerThread = handlerThread;
                }
            });
        }
    }

    private final void restart(Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mRestartDisposable = Completable.timer((long)configuration.getRestartDelay(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe(new Action(this, configuration, handlerThread){
            final /* synthetic */ WifiRepositoryImpl this$0;
            final /* synthetic */ Configuration.WifiDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                WifiRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Logger.INSTANCE.d("restart").with(this.this$0).print();
                if (WifiRepositoryImpl.access$isStarted(this.this$0)) {
                    WifiRepositoryImpl.access$scheduledNextScan(this.this$0, this.$configuration, this.$handlerThread);
                }
            }
            {
                this.this$0 = wifiRepositoryImpl;
                this.$configuration = wifiDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ WifiRepositoryImpl this$0;
            final /* synthetic */ Configuration.WifiDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                WifiRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                WifiRepositoryImpl.access$sendError(this.this$0, new GeoException.WifiRestart(throwable));
                WifiRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = wifiRepositoryImpl;
                this.$configuration = wifiDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    @Inject
    public WifiRepositoryImpl(@NotNull Context mContext, @NotNull LocalPreferences mLocalPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)mLocalPreferences, (String)"mLocalPreferences");
        this.mContext = mContext;
        this.mLocalPreferences = mLocalPreferences;
        Object object = ContextCompat.getSystemService((Context)this.mContext, WifiManager.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ContextCompat.getSystemS\u2026ifiManager::class.java)!!");
        this.mWifiManager = (WifiManager)object;
        Object object2 = ContextCompat.getSystemService((Context)this.mContext, ConnectivityManager.class);
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"ContextCompat.getSystemS\u2026ityManager::class.java)!!");
        this.mConnectivityManager = (ConnectivityManager)object2;
        this.mWifiStateBeforeStart = this.mWifiManager.isWifiEnabled();
        this.mWifiScanReceiver = new BroadcastReceiver(this){
            final /* synthetic */ WifiRepositoryImpl this$0;

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                boolean success;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0).print();
                if (!WifiRepositoryImpl.access$isStarted(this.this$0)) {
                    return;
                }
                WifiRepositoryImpl.access$stopWifiScan(this.this$0);
                boolean bl = success = Build.VERSION.SDK_INT >= 23 ? intent.getBooleanExtra("resultsUpdated", false) : true;
                if (success) {
                    List list = WifiRepositoryImpl.access$getMWifiManager$p(this.this$0).getScanResults();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"mWifiManager.scanResults");
                    WifiRepositoryImpl.access$sendEvent(this.this$0, new WifisEvent(null, WifiListFactory.INSTANCE.createFromScanResults(list, WifiUtil.INSTANCE.getCurrentSsid(WifiRepositoryImpl.access$getMConnectivityManager$p(this.this$0), WifiRepositoryImpl.access$getMWifiManager$p(this.this$0))), 1, null));
                    WifiRepositoryImpl.access$scheduledNextScan(this.this$0, WifiRepositoryImpl.access$getMConfiguration$p(this.this$0), WifiRepositoryImpl.access$getMHandlerThread$p(this.this$0));
                } else {
                    WifiRepositoryImpl.access$sendError(this.this$0, new GeoException.WifiScanFailure());
                    WifiRepositoryImpl.access$restart(this.this$0, WifiRepositoryImpl.access$getMConfiguration$p(this.this$0), WifiRepositoryImpl.access$getMHandlerThread$p(this.this$0));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ ConnectivityManager access$getMConnectivityManager$p(WifiRepositoryImpl $this) {
        return $this.mConnectivityManager;
    }

    public static final /* synthetic */ WifiManager access$getMWifiManager$p(WifiRepositoryImpl $this) {
        return $this.mWifiManager;
    }

    public static final /* synthetic */ Disposable access$getMNextScanDisposable$p(WifiRepositoryImpl $this) {
        return $this.mNextScanDisposable;
    }

    public static final /* synthetic */ void access$setMNextScanDisposable$p(WifiRepositoryImpl $this, Disposable disposable) {
        $this.mNextScanDisposable = disposable;
    }

    public static final /* synthetic */ boolean access$isStarted(WifiRepositoryImpl $this) {
        return $this.isStarted();
    }

    public static final /* synthetic */ void access$startWifiScan(WifiRepositoryImpl $this, Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        $this.startWifiScan(configuration, handlerThread);
    }

    public static final /* synthetic */ void access$sendError(WifiRepositoryImpl $this, GeoException geoException) {
        $this.sendError(geoException);
    }

    public static final /* synthetic */ void access$restart(WifiRepositoryImpl $this, Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        $this.restart(configuration, handlerThread);
    }

    public static final /* synthetic */ Disposable access$getMRestartDisposable$p(WifiRepositoryImpl $this) {
        return $this.mRestartDisposable;
    }

    public static final /* synthetic */ void access$setMRestartDisposable$p(WifiRepositoryImpl $this, Disposable disposable) {
        $this.mRestartDisposable = disposable;
    }

    public static final /* synthetic */ void access$scheduledNextScan(WifiRepositoryImpl $this, Configuration.WifiDataConfiguration configuration, HandlerThread handlerThread) {
        $this.scheduledNextScan(configuration, handlerThread);
    }

    public static final /* synthetic */ void access$stopWifiScan(WifiRepositoryImpl $this) {
        $this.stopWifiScan();
    }

    public static final /* synthetic */ void access$sendEvent(WifiRepositoryImpl $this, WifisEvent t) {
        $this.sendEvent(t);
    }

    public static final /* synthetic */ Configuration.WifiDataConfiguration access$getMConfiguration$p(WifiRepositoryImpl $this) {
        Configuration.WifiDataConfiguration wifiDataConfiguration = $this.mConfiguration;
        if (wifiDataConfiguration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mConfiguration");
        }
        return wifiDataConfiguration;
    }

    public static final /* synthetic */ void access$setMConfiguration$p(WifiRepositoryImpl $this, Configuration.WifiDataConfiguration wifiDataConfiguration) {
        $this.mConfiguration = wifiDataConfiguration;
    }

    public static final /* synthetic */ HandlerThread access$getMHandlerThread$p(WifiRepositoryImpl $this) {
        HandlerThread handlerThread = $this.mHandlerThread;
        if (handlerThread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mHandlerThread");
        }
        return handlerThread;
    }

    public static final /* synthetic */ void access$setMHandlerThread$p(WifiRepositoryImpl $this, HandlerThread handlerThread) {
        $this.mHandlerThread = handlerThread;
    }
}

