/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.remote;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.core.content.ContextCompat;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.model.Session;
import org.findmykids.geo.data.network.SocketClient;
import org.findmykids.geo.data.network.model.SocketData;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.repository.live.remote.RemoteEvent;
import org.findmykids.geo.data.repository.live.remote.RemoteEventFactory;
import org.findmykids.geo.data.repository.live.remote.RemoteRepository;
import org.findmykids.geo.data.repository.live.remote.RemoteRepositoryImpl;
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u000eH\u0014J\u0010\u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u000eH\u0002J\b\u0010(\u001a\u00020\"H\u0014J\b\u0010)\u001a\u00020\"H\u0002J\b\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/findmykids/geo/data/repository/live/remote/RemoteRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/remote/RemoteRepository;", "mSocketClient", "Lorg/findmykids/geo/data/network/SocketClient;", "mContext", "Landroid/content/Context;", "mCurrentSessionRepository", "Lorg/findmykids/geo/data/repository/storage/currentSession/CurrentSessionRepository;", "mLocalPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "(Lorg/findmykids/geo/data/network/SocketClient;Landroid/content/Context;Lorg/findmykids/geo/data/repository/storage/currentSession/CurrentSessionRepository;Lorg/findmykids/geo/data/preferences/LocalPreferences;)V", "mConfiguration", "Lorg/findmykids/geo/data/model/Configuration$RemoteDataConfiguration;", "mHandlerThread", "Landroid/os/HandlerThread;", "mIsActiveListenNetworkState", "", "mNetworkCallback", "Landroid/net/ConnectivityManager$NetworkCallback;", "getMNetworkCallback", "()Landroid/net/ConnectivityManager$NetworkCallback;", "mNetworkCallback$delegate", "Lkotlin/Lazy;", "mNetworkChangeReceiver", "Landroid/content/BroadcastReceiver;", "getMNetworkChangeReceiver", "()Landroid/content/BroadcastReceiver;", "mNetworkChangeReceiver$delegate", "mRestartDisposable", "Lio/reactivex/disposables/Disposable;", "mRetryCount", "", "mSocketDisposable", "reconnectIfNeed", "", "restart", "configuration", "handlerThread", "start", "startListenNetworkState", "stop", "stopListenNetworkState", "toString", "", "geo_release"})
public final class RemoteRepositoryImpl
extends RemoteRepository {
    private Configuration.RemoteDataConfiguration mConfiguration;
    private HandlerThread mHandlerThread;
    private Disposable mSocketDisposable;
    private Disposable mRestartDisposable;
    private int mRetryCount;
    private volatile boolean mIsActiveListenNetworkState;
    private final Lazy mNetworkChangeReceiver$delegate;
    private final Lazy mNetworkCallback$delegate;
    private final SocketClient mSocketClient;
    private final Context mContext;
    private final CurrentSessionRepository mCurrentSessionRepository;
    private final LocalPreferences mLocalPreferences;

    private final BroadcastReceiver getMNetworkChangeReceiver() {
        Lazy lazy = this.mNetworkChangeReceiver$delegate;
        RemoteRepositoryImpl remoteRepositoryImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (BroadcastReceiver)lazy.getValue();
    }

    private final ConnectivityManager.NetworkCallback getMNetworkCallback() {
        Lazy lazy = this.mNetworkCallback$delegate;
        RemoteRepositoryImpl remoteRepositoryImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConnectivityManager.NetworkCallback)lazy.getValue();
    }

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    protected void start(@NotNull Configuration.RemoteDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        this.mConfiguration = configuration;
        this.mHandlerThread = handlerThread;
        Disposable disposable = this.mRestartDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mRestartDisposable = null;
        this.mSocketDisposable = Observable.create((ObservableOnSubscribe)this.mSocketClient).subscribe((Consumer)new Consumer<SocketData>(this){
            final /* synthetic */ RemoteRepositoryImpl this$0;

            public final void accept(SocketData socketData) {
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(socketData).with(this.this$0).print();
                RemoteRepositoryImpl.access$setMRetryCount$p(this.this$0, 0);
                try {
                    SocketData socketData2 = socketData;
                    Intrinsics.checkExpressionValueIsNotNull((Object)socketData2, (String)"socketData");
                    RemoteRepositoryImpl.access$sendEvent(this.this$0, RemoteEventFactory.INSTANCE.createSocketEvent(socketData2));
                }
                catch (Exception e) {
                    RemoteRepositoryImpl.access$sendError(this.this$0, new GeoException.InvalidSocketData(e));
                }
            }
            {
                this.this$0 = remoteRepositoryImpl;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ RemoteRepositoryImpl this$0;
            final /* synthetic */ Configuration.RemoteDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                if (it instanceof GeoException) {
                    RemoteRepositoryImpl.access$sendError(this.this$0, (GeoException)it);
                    if (it instanceof GeoException.SocketInvalidUserId) {
                        RemoteRepositoryImpl.access$getMLocalPreferences$p(this.this$0).setUserId(((GeoException.SocketInvalidUserId)it).getUserId());
                    }
                } else {
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    RemoteRepositoryImpl.access$sendError(this.this$0, new GeoException.Socket(throwable));
                }
                RemoteRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = remoteRepositoryImpl;
                this.$configuration = remoteDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
        if (!this.mIsActiveListenNetworkState) {
            this.startListenNetworkState(handlerThread);
        }
    }

    @Override
    protected void stop() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        if (this.mIsActiveListenNetworkState) {
            this.stopListenNetworkState();
        }
        Disposable disposable = this.mSocketDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mSocketDisposable = null;
        Disposable disposable2 = this.mRestartDisposable;
        if (disposable2 != null) {
            disposable2.dispose();
        }
        this.mRestartDisposable = null;
    }

    private final synchronized void reconnectIfNeed() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        if (this.mSocketDisposable == null) {
            Disposable disposable = this.mRestartDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
            this.mRestartDisposable = null;
            if (this.isStarted()) {
                Configuration.RemoteDataConfiguration remoteDataConfiguration = this.mConfiguration;
                if (remoteDataConfiguration == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mConfiguration");
                }
                HandlerThread handlerThread = this.mHandlerThread;
                if (handlerThread == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mHandlerThread");
                }
                this.start(remoteDataConfiguration, handlerThread);
            }
        }
    }

    private final synchronized void restart(Configuration.RemoteDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mSocketDisposable = null;
        this.mRestartDisposable = this.mCurrentSessionRepository.getSession().map(new Function<T, R>(this, configuration){
            final /* synthetic */ RemoteRepositoryImpl this$0;
            final /* synthetic */ Configuration.RemoteDataConfiguration $configuration;

            public final long apply(@NotNull Session it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(it).with(this.this$0).print();
                long delay = it.isRealtime() ? this.$configuration.getRealtimeDelay() : this.$configuration.getStartDelay() + (long)RemoteRepositoryImpl.access$getMRetryCount$p(this.this$0) * this.$configuration.getStepDelay();
                RemoteRepositoryImpl remoteRepositoryImpl = this.this$0;
                int n = RemoteRepositoryImpl.access$getMRetryCount$p(remoteRepositoryImpl);
                RemoteRepositoryImpl.access$setMRetryCount$p(remoteRepositoryImpl, n + 1);
                long l = this.$configuration.getMaxDelay();
                boolean bl = false;
                return Math.min(delay, l);
            }
            {
                this.this$0 = remoteRepositoryImpl;
                this.$configuration = remoteDataConfiguration;
            }
        }).flatMapCompletable((Function)new Function<Long, CompletableSource>(this){
            final /* synthetic */ RemoteRepositoryImpl this$0;

            @NotNull
            public final Completable apply(@NotNull Long it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(it).with(this.this$0).print();
                return Completable.timer((long)it, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread());
            }
            {
                this.this$0 = remoteRepositoryImpl;
            }
        }).subscribe(new Action(this, configuration, handlerThread){
            final /* synthetic */ RemoteRepositoryImpl this$0;
            final /* synthetic */ Configuration.RemoteDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                RemoteRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Logger.INSTANCE.d("restart").with(this.this$0).print();
                if (RemoteRepositoryImpl.access$isStarted(this.this$0)) {
                    this.this$0.start(this.$configuration, this.$handlerThread);
                }
            }
            {
                this.this$0 = remoteRepositoryImpl;
                this.$configuration = remoteDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ RemoteRepositoryImpl this$0;
            final /* synthetic */ Configuration.RemoteDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                RemoteRepositoryImpl.access$setMRestartDisposable$p(this.this$0, null);
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                RemoteRepositoryImpl.access$sendError(this.this$0, new GeoException.SocketRestart(throwable));
                RemoteRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = remoteRepositoryImpl;
                this.$configuration = remoteDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    private final void startListenNetworkState(HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mIsActiveListenNetworkState = true;
        if (Build.VERSION.SDK_INT >= 24) {
            ConnectivityManager connectivityManager = (ConnectivityManager)ContextCompat.getSystemService((Context)this.mContext, ConnectivityManager.class);
            if (Build.VERSION.SDK_INT >= 26) {
                ConnectivityManager connectivityManager2 = connectivityManager;
                if (connectivityManager2 != null) {
                    connectivityManager2.registerDefaultNetworkCallback(this.getMNetworkCallback(), new Handler(handlerThread.getLooper()));
                }
            } else {
                ConnectivityManager connectivityManager3 = connectivityManager;
                if (connectivityManager3 != null) {
                    connectivityManager3.registerDefaultNetworkCallback(this.getMNetworkCallback());
                }
            }
        } else {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            this.mContext.registerReceiver(this.getMNetworkChangeReceiver(), intentFilter, null, new Handler(handlerThread.getLooper()));
        }
    }

    private final void stopListenNetworkState() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mIsActiveListenNetworkState = false;
        if (Build.VERSION.SDK_INT >= 24) {
            ConnectivityManager connectivityManager;
            ConnectivityManager connectivityManager2 = connectivityManager = (ConnectivityManager)ContextCompat.getSystemService((Context)this.mContext, ConnectivityManager.class);
            if (connectivityManager2 != null) {
                connectivityManager2.unregisterNetworkCallback(this.getMNetworkCallback());
            }
        } else {
            this.mContext.unregisterReceiver(this.getMNetworkChangeReceiver());
        }
    }

    @Inject
    public RemoteRepositoryImpl(@NotNull SocketClient mSocketClient, @NotNull Context mContext, @NotNull CurrentSessionRepository mCurrentSessionRepository, @NotNull LocalPreferences mLocalPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)mSocketClient, (String)"mSocketClient");
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)mCurrentSessionRepository, (String)"mCurrentSessionRepository");
        Intrinsics.checkParameterIsNotNull((Object)mLocalPreferences, (String)"mLocalPreferences");
        this.mSocketClient = mSocketClient;
        this.mContext = mContext;
        this.mCurrentSessionRepository = mCurrentSessionRepository;
        this.mLocalPreferences = mLocalPreferences;
        this.mNetworkChangeReceiver$delegate = LazyKt.lazy((Function0)((Function0)new Function0<mNetworkChangeReceiver.1>(this){
            final /* synthetic */ RemoteRepositoryImpl this$0;

            @NotNull
            public final mNetworkChangeReceiver.1 invoke() {
                return new BroadcastReceiver(this){
                    final /* synthetic */ mNetworkChangeReceiver.2 this$0;

                    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
                        RemoteRepositoryImpl.access$reconnectIfNeed(this.this$0.this$0);
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.this$0 = remoteRepositoryImpl;
                super(0);
            }
        }));
        this.mNetworkCallback$delegate = LazyKt.lazy((Function0)((Function0)new Function0<mNetworkCallback.1>(this){
            final /* synthetic */ RemoteRepositoryImpl this$0;

            @NotNull
            public final mNetworkCallback.1 invoke() {
                return new ConnectivityManager.NetworkCallback(this){
                    final /* synthetic */ mNetworkCallback.2 this$0;

                    public void onAvailable(@NotNull Network network) {
                        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
                        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
                        RemoteRepositoryImpl.access$reconnectIfNeed(this.this$0.this$0);
                    }

                    public void onLost(@NotNull Network network) {
                        Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.this$0 = remoteRepositoryImpl;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ int access$getMRetryCount$p(RemoteRepositoryImpl $this) {
        return $this.mRetryCount;
    }

    public static final /* synthetic */ void access$setMRetryCount$p(RemoteRepositoryImpl $this, int n) {
        $this.mRetryCount = n;
    }

    public static final /* synthetic */ void access$sendEvent(RemoteRepositoryImpl $this, RemoteEvent t) {
        $this.sendEvent(t);
    }

    public static final /* synthetic */ void access$sendError(RemoteRepositoryImpl $this, GeoException geoException) {
        $this.sendError(geoException);
    }

    public static final /* synthetic */ LocalPreferences access$getMLocalPreferences$p(RemoteRepositoryImpl $this) {
        return $this.mLocalPreferences;
    }

    public static final /* synthetic */ void access$restart(RemoteRepositoryImpl $this, Configuration.RemoteDataConfiguration configuration, HandlerThread handlerThread) {
        $this.restart(configuration, handlerThread);
    }

    public static final /* synthetic */ Disposable access$getMRestartDisposable$p(RemoteRepositoryImpl $this) {
        return $this.mRestartDisposable;
    }

    public static final /* synthetic */ void access$setMRestartDisposable$p(RemoteRepositoryImpl $this, Disposable disposable) {
        $this.mRestartDisposable = disposable;
    }

    public static final /* synthetic */ boolean access$isStarted(RemoteRepositoryImpl $this) {
        return $this.isStarted();
    }

    public static final /* synthetic */ void access$reconnectIfNeed(RemoteRepositoryImpl $this) {
        $this.reconnectIfNeed();
    }
}

