/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import android.os.HandlerThread;
import androidx.annotation.RequiresPermission;
import androidx.core.content.ContextCompat;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.LocationManagerUtil;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.model.LocationSource;
import org.findmykids.geo.data.repository.live.location.LocationFactory;
import org.findmykids.geo.data.repository.live.location.LocationSourceProvider;
import org.findmykids.geo.data.repository.live.location.LocationSourceProviderGoogleFusedImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000*\u0001\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/findmykids/geo/data/repository/live/location/LocationSourceProviderGoogleFusedImpl;", "Lorg/findmykids/geo/data/repository/live/location/LocationSourceProvider;", "mContext", "Landroid/content/Context;", "mCallback", "Lorg/findmykids/geo/data/repository/live/location/LocationSourceProvider$Callback;", "mHandlerThread", "Landroid/os/HandlerThread;", "(Landroid/content/Context;Lorg/findmykids/geo/data/repository/live/location/LocationSourceProvider$Callback;Landroid/os/HandlerThread;)V", "mLocationCallback", "org/findmykids/geo/data/repository/live/location/LocationSourceProviderGoogleFusedImpl$mLocationCallback$1", "Lorg/findmykids/geo/data/repository/live/location/LocationSourceProviderGoogleFusedImpl$mLocationCallback$1;", "start", "", "configuration", "Lorg/findmykids/geo/data/model/Configuration$LocationDataConfiguration;", "stop", "toString", "", "geo_release"})
public final class LocationSourceProviderGoogleFusedImpl
implements LocationSourceProvider {
    private mLocationCallback.1 mLocationCallback;
    private final Context mContext;
    private final LocationSourceProvider.Callback mCallback;
    private final HandlerThread mHandlerThread;

    @NotNull
    public String toString() {
        return "";
    }

    @Override
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void start(@NotNull Configuration.LocationDataConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        Object object = ContextCompat.getSystemService((Context)this.mContext, LocationManager.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        if (LocationManagerUtil.INSTANCE.isEnabled((LocationManager)object)) {
            LocationRequest locationRequest = new LocationRequest().setInterval(configuration.getInterval()).setPriority(configuration.getPriority()).setFastestInterval(configuration.getFastestInterval()).setMaxWaitTime(configuration.getMaxWaitTime());
            if (configuration.getSmallestDisplacement() > 0.0f) {
                LocationRequest locationRequest2 = locationRequest;
                Intrinsics.checkExpressionValueIsNotNull((Object)locationRequest2, (String)"locationRequest");
                locationRequest2.setSmallestDisplacement(configuration.getSmallestDisplacement());
            }
            try {
                Tasks.await((Task)LocationServices.getFusedLocationProviderClient((Context)this.mContext).requestLocationUpdates(locationRequest, (LocationCallback)this.mLocationCallback, this.mHandlerThread.getLooper()), (long)10L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw (Throwable)new GeoException.GoogleFusedStart(e);
            }
        } else {
            throw (Throwable)new GeoException.GoogleFusedLocationManagerIsNotEnabled();
        }
    }

    @Override
    public void stop() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        try {
            Tasks.await((Task)LocationServices.getFusedLocationProviderClient((Context)this.mContext).removeLocationUpdates((LocationCallback)this.mLocationCallback), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw (Throwable)new GeoException.GoogleFusedStop(e);
        }
    }

    public LocationSourceProviderGoogleFusedImpl(@NotNull Context mContext, @NotNull LocationSourceProvider.Callback mCallback2, @NotNull HandlerThread mHandlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)mCallback2, (String)"mCallback");
        Intrinsics.checkParameterIsNotNull((Object)mHandlerThread, (String)"mHandlerThread");
        this.mContext = mContext;
        this.mCallback = mCallback2;
        this.mHandlerThread = mHandlerThread;
        this.mLocationCallback = new LocationCallback(this){
            final /* synthetic */ LocationSourceProviderGoogleFusedImpl this$0;

            public void onLocationResult(@Nullable LocationResult locationResult) {
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(locationResult).print();
                if (locationResult == null) {
                    return;
                }
                for (Location location : locationResult.getLocations()) {
                    LocationSourceProvider.Callback callback = LocationSourceProviderGoogleFusedImpl.access$getMCallback$p(this.this$0);
                    Location location2 = location;
                    Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
                    callback.onLocation(LocationFactory.INSTANCE.createLocation(location2, LocationSource.GOOGLE_FUSED));
                }
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ LocationSourceProvider.Callback access$getMCallback$p(LocationSourceProviderGoogleFusedImpl $this) {
        return $this.mCallback;
    }
}

