package org.findmykids.geo.data.repository.trigger.station.huawei

import android.content.Context
import android.content.Intent
import com.huawei.hms.location.GeofenceData
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.repository.trigger.station.BaseStationReceiver
import org.findmykids.geo.data.repository.trigger.station.StationEventFactory


internal class StationHuaweiReceiver : BaseStationReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        Logger.d().print()
        GeofenceData.getDataFromIntent(intent)?.let {
            Logger.d().addArg(it).with(this@StationHuaweiReceiver).print()
            send(context, StationEventFactory.createFromGeofenceData(it))
        }
    }
}