package org.findmykids.geo.data.repository.live.wifi

import android.net.wifi.ScanResult
import android.os.Build
import org.findmykids.geo.data.model.WifiFull


internal object WifiListFactory {
    fun createFromScanResults(scanResults: List<ScanResult>, currentSSID: String?) = scanResults
        .map {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                WifiFull(
                    it.SSID,
                    it.BSSID,
                    it.capabilities,
                    it.frequency,
                    it.level,
                    it.timestamp,
                    it.SSID == currentSSID
                )
            } else {
                WifiFull(
                    it.SSID,
                    it.BSSID,
                    it.capabilities,
                    it.frequency,
                    it.level,
                    null,
                    it.SSID == currentSSID
                )
            }
        }
}