package org.findmykids.geo.data.repository.live.remote

import org.findmykids.geo.data.model.Configurations
import org.findmykids.geo.data.model.Zones


internal sealed class RemoteEvent {
    /**
     * Подключились к бэкенды
     */
    object Created : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Отключились от бэкенда
     */
    object Deactivate : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Запросилил последнюю координаты (не используется)
     */
    object Request : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Переспросил последнюю координаты (не используется)
     */
    object ReRequest : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Изменилась конфигурации
     */
    class ConfigurationsChanged(
        val configurations: Configurations
    ) : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Изменилась зона безопасности (не используется)
     */
    class ZoneChanged(
        val zones: Zones
    ) : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.declaredFields[0].name}=$zones)"
        }
    }

    /**
     * Включить реалтайм
     */
    object RealtimeBegin : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }

    /**
     * Выключить реалтайм
     */
    object RealtimeEnd : RemoteEvent() {
        override fun toString(): String {
            return "${this::class.simpleName}()"
        }
    }


    override fun toString(): String = ""
}