package org.findmykids.geo.data.repository.live.activity

import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Activity
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.repository.live.BaseLiveRepository


internal abstract class ActivityRepository : BaseLiveRepository<Configuration.ActivityDataConfiguration, ActivityEvent>() {
    fun send(activity: Activity) {
        Logger.d().addArg(activity).with(this@ActivityRepository).print()
        if (isStarted() && activity.activitiesWithConfidences.isNotEmpty()) {
            sendEvent(ActivityEvent(activity))
        }
    }
}