package org.findmykids.geo.data.network.factory

import org.findmykids.geo.common.extensions.getLongAt
import org.findmykids.geo.common.extensions.getShortAt
import org.findmykids.geo.data.network.model.SocketCommand
import org.findmykids.geo.data.network.model.SocketData


internal object SocketDataFactory {
    fun createSocketData(byteArray: ByteArray): SocketData {
        val headerLength = byteArray.getShortAt(0)
        return SocketData(
            byteArray.copyOfRange(headerLength.toInt(), byteArray.size),
            headerLength,
            SocketCommand.getById(byteArray.getShortAt(2))!!,
            byteArray.getShortAt(4),
            byteArray.getShortAt(6),
            byteArray.getLongAt(8),
            byteArray.getLongAt(16),
            byteArray.getLongAt(24)
        )
    }
}