package org.findmykids.geo.data.model


data class LocatorLocation(
    /**
     * Get the latitude, in degrees.
     */
    val latitude: Double,
    /**
     * Get the longitude, in degrees.
     */
    val longitude: Double,

    val altitude: Double,

    val accuracy: Double,

    val altitudePrecision: Double,

    val type: String,
    /**
     * Create time.
     */
    val time: Long
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[3].name}=$latitude, " +
                "${this::class.java.declaredFields[4].name}=$longitude, " +
                "${this::class.java.declaredFields[1].name}=$altitude, " +
                "${this::class.java.declaredFields[0].name}=$accuracy, " +
                "${this::class.java.declaredFields[2].name}=$altitudePrecision, " +
                "${this::class.java.declaredFields[6].name}=$type, " +
                "${this::class.java.declaredFields[5].name}=$time)"
    }


    companion object {
        const val PROVIDER = "Locator"
    }
}