package org.findmykids.geo.data.model


data class Location(
    /**
     * Get the latitude, in degrees.
     */
    val latitude: Double,
    /**
     * Get the longitude, in degrees.
     */
    val longitude: Double,
    /**
     * Returns the name of the provider that generated this fix.
     */
    val provider: String,
    /**
     * Return the UTC time of this fix, in milliseconds since January 1, 1970.
     */
    val time: Long,
    /**
     * Get the altitude if available, in meters above the WGS 84 reference ellipsoid.
     */
    val altitude: Double?,
    /**
     * Get the estimated horizontal accuracy of this location, radial, in meters.
     */
    val accuracy: Float?,
    /**
     * Get the bearing, in degrees.
     */
    val bearing: Float?,
    /**
     * Get estimate of the relative precision of the alignment of the ElapsedRealtimeNanos timestamp, with the reported measurements in nanoseconds (68% confidence).
     */
    val elapsedRealtimeUncertaintyNanos: Double?,
    /**
     * Get the speed if it is available, in meters/second over ground.
     */
    val speed: Float?,
    /**
     * Get the estimated speed accuracy of this location, in meters per second.
     */
    val speedAccuracyMetersPerSecond: Float?,
    /**
     * Get the estimated vertical accuracy of this location, in meters.
     */
    val verticalAccuracyMeters: Float?,
    /**
     * Get the estimated bearing accuracy of this location, in degrees.
     */
    val bearingAccuracyDegrees: Float?,
    /**
     * Return the time of this fix, in elapsed real-time since system boot.
     */
    val elapsedRealtimeNanos: Long?,
    /**
     * Location provider name
     */
    val source: LocationSource
) {
    override fun toString(): String {
        return "${this::class.simpleName}(" +
                "${this::class.java.declaredFields[6].name}=$latitude, " +
                "${this::class.java.declaredFields[7].name}=$longitude, " +
                "${this::class.java.declaredFields[8].name}=$provider, " +
                "${this::class.java.declaredFields[12].name}=$time, " +
                "${this::class.java.declaredFields[1].name}=$altitude, " +
                "${this::class.java.declaredFields[0].name}=$accuracy, " +
                "${this::class.java.declaredFields[2].name}=$bearing, " +
                "${this::class.java.declaredFields[5].name}=$elapsedRealtimeUncertaintyNanos, " +
                "${this::class.java.declaredFields[10].name}=$speed, " +
                "${this::class.java.declaredFields[11].name}=$speedAccuracyMetersPerSecond, " +
                "${this::class.java.declaredFields[13].name}=$verticalAccuracyMeters, " +
                "${this::class.java.declaredFields[3].name}=$bearingAccuracyDegrees, " +
                "${this::class.java.declaredFields[4].name}=$elapsedRealtimeNanos, " +
                "${this::class.java.declaredFields[9].name}=$source)"
    }


    companion object {
        fun distanceBetween(locationA: Location, locationB: Location): Float {
            val locA = android.location.Location("A")
                .apply {
                    latitude = locationA.latitude
                    longitude = locationA.longitude
                }
            val locB = android.location.Location("B")
                .apply {
                    latitude = locationB.latitude
                    longitude = locationB.longitude
                }
            return locA.distanceTo(locB)
        }
    }
}