package org.findmykids.geo.data.db.factory

import org.findmykids.geo.data.db.model.ErrorEntity
import org.findmykids.geo.data.model.Error


internal object ErrorEntityFactory {
    fun create(error: Error) = ErrorEntity(
        create = error.create,
        sessionIndex = error.session.index,
        sessionCreate = error.session.create,
        sessionIsRealtime = error.session.isRealtime,
        sessionCommandsTypes = error.session.commandsTypes,
        activityExist = error.activity != null,
        activityElapsedRealtimeMillis = error.activity?.elapsedRealtimeMillis,
        activityTime = error.activity?.time,
        activityActivitiesWithConfidences = error.activity?.activitiesWithConfidences,
        batteryExist = error.battery != null,
        batteryIsCharging = error.battery?.isCharging,
        batteryLevel = error.battery?.level,
        text = error.text
    )
}