package org.findmykids.geo.common.logger

import io.reactivex.annotations.CheckReturnValue
import java.io.PrintWriter
import java.io.StringWriter
import java.io.Writer


internal object Logger {
    @CheckReturnValue
    fun d(message: String? = null): LogBuilder {
        return LogBuilder(LogType.DEBUG, message)
    }

    @CheckReturnValue
    fun i(message: String? = null): LogBuilder {
        return LogBuilder(LogType.INFO, message)
    }

//    @CheckReturnValue
//    fun w(message: String? = null): LogBuilder {
//        return LogBuilder(LogType.WARNING, message)
//    }

    @CheckReturnValue
    fun w(throwable: Throwable): LogBuilder {
        return LogBuilder(LogType.WARNING, throwable.toString())
    }

    @CheckReturnValue
    fun e(throwable: Throwable): LogBuilder {
        throwable.printStackTrace()
        val writer: Writer = StringWriter()
        throwable.printStackTrace(PrintWriter(writer))
        val stackTrace = writer.toString()
        return LogBuilder(LogType.ERROR, throwable.toString() + "\n" + stackTrace)
    }
}