/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.domain.factory;

import android.content.Intent;
import com.google.gson.Gson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.model.ActivityEvent;
import org.findmykids.geo.data.model.Location;
import org.findmykids.geo.data.model.StationEvent;
import org.findmykids.geo.data.model.ZoneEvent;
import org.findmykids.geo.data.repository.trigger.task.Tasks;
import org.findmykids.geo.domain.model.Command;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/findmykids/geo/domain/factory/CommandFactory;", "", "()V", "createInnerCommand", "Lorg/findmykids/geo/domain/model/Command;", "intent", "Landroid/content/Intent;", "geo_release"})
public final class CommandFactory {
    public static final CommandFactory INSTANCE;

    @NotNull
    public final Command createInnerCommand(@NotNull Intent intent) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        try {
            Command command;
            object = intent.getAction();
            if (Intrinsics.areEqual((Object)object, (Object)"ACTION_TIMER_ALARM")) {
                Logger.INSTANCE.d("Timer Alarm").print();
                command = new Command.Timer();
            } else if (Intrinsics.areEqual((Object)object, (Object)"ACTION_PASSIVE")) {
                Location location;
                Logger.INSTANCE.d("Passive").print();
                String textLocation = intent.getStringExtra("EXTRA_LOCATION");
                Location location2 = location = (Location)new Gson().fromJson(textLocation, Location.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)location2, (String)"location");
                command = new Command.Passive(location2);
            } else if (Intrinsics.areEqual((Object)object, (Object)"ACTION_ACTIVITY")) {
                ActivityEvent activityTransitionsEvent;
                Logger.INSTANCE.d("Activity").print();
                String textActivityTransitionsEvent = intent.getStringExtra("EXTRA_ACTIVITY_EVENT");
                ActivityEvent activityEvent = activityTransitionsEvent = (ActivityEvent)new Gson().fromJson(textActivityTransitionsEvent, ActivityEvent.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)activityEvent, (String)"activityTransitionsEvent");
                command = new Command.Activity(activityEvent);
            } else if (Intrinsics.areEqual((Object)object, (Object)"ACTION_ZONE")) {
                ZoneEvent zoneEvent;
                Logger.INSTANCE.d("Zone").print();
                String textZoneEvent = intent.getStringExtra("EXTRA_ZONE_EVENT");
                ZoneEvent zoneEvent2 = zoneEvent = (ZoneEvent)new Gson().fromJson(textZoneEvent, ZoneEvent.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)zoneEvent2, (String)"zoneEvent");
                command = new Command.Zone(zoneEvent2);
            } else if (Intrinsics.areEqual((Object)object, (Object)"ACTION_STATION")) {
                StationEvent stationEvent;
                Logger.INSTANCE.d("Station").print();
                String textStationEvent = intent.getStringExtra("EXTRA_STATION_EVENT");
                StationEvent stationEvent2 = stationEvent = (StationEvent)new Gson().fromJson(textStationEvent, StationEvent.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)stationEvent2, (String)"stationEvent");
                command = new Command.Station(stationEvent2);
            } else if (Intrinsics.areEqual((Object)object, (Object)"ACTION_BOOT")) {
                Logger.INSTANCE.d("Boot").print();
                command = new Command.Boot();
            } else if (Intrinsics.areEqual((Object)object, (Object)Tasks.ACTIVATE.name())) {
                Logger.INSTANCE.d("Activate").print();
                String string = intent.getStringExtra("BaseUrl");
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                char[] cArray = intent.getCharArrayExtra("ApiKey");
                if (cArray == null) {
                    Intrinsics.throwNpe();
                }
                char[] cArray2 = intent.getCharArrayExtra("UserToken");
                if (cArray2 == null) {
                    Intrinsics.throwNpe();
                }
                char[] cArray3 = intent.getCharArrayExtra("UserId");
                if (cArray3 == null) {
                    Intrinsics.throwNpe();
                }
                command = new Command.Activate(string, cArray, cArray2, cArray3);
            } else if (Intrinsics.areEqual((Object)object, (Object)Tasks.DEACTIVATE.name())) {
                Logger.INSTANCE.d("Deactivate").print();
                command = new Command.Deactivate();
            } else if (Intrinsics.areEqual((Object)object, (Object)Tasks.PING.name())) {
                Logger.INSTANCE.d("Ping").print();
                command = new Command.Ping();
            } else if (Intrinsics.areEqual((Object)object, (Object)Tasks.REQUEST.name())) {
                Logger.INSTANCE.d("Request").print();
                command = new Command.Request();
            } else if (Intrinsics.areEqual((Object)object, (Object)Tasks.REAL_TIME.name())) {
                Logger.INSTANCE.d("RealTime").print();
                command = new Command.Realtime(intent.getBooleanExtra("RealTimeEnabled", false));
            } else {
                Logger.INSTANCE.d("Not supported action").print();
                throw (Throwable)new GeoException.NotSupportedAction(intent.getAction());
            }
            object = command;
        }
        catch (Throwable t) {
            object = new Command.Invalid(t);
        }
        return object;
    }

    private CommandFactory() {
    }

    static {
        CommandFactory commandFactory;
        INSTANCE = commandFactory = new CommandFactory();
    }
}

