/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.remote;

import geocoreproto.ConfigAndroid;
import geocoreproto.SafeZones;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.data.network.model.SocketData;
import org.findmykids.geo.data.repository.live.remote.ConfigurationsFactory;
import org.findmykids.geo.data.repository.live.remote.RemoteEvent;
import org.findmykids.geo.data.repository.live.remote.RemoteEventFactory$WhenMappings;
import org.findmykids.geo.data.repository.live.remote.ZonesFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/findmykids/geo/data/repository/live/remote/RemoteEventFactory;", "", "()V", "createSocketEvent", "Lorg/findmykids/geo/data/repository/live/remote/RemoteEvent;", "socketData", "Lorg/findmykids/geo/data/network/model/SocketData;", "geo_release"})
public final class RemoteEventFactory {
    public static final RemoteEventFactory INSTANCE;

    @NotNull
    public final RemoteEvent createSocketEvent(@NotNull SocketData socketData) {
        RemoteEvent remoteEvent;
        Intrinsics.checkParameterIsNotNull((Object)socketData, (String)"socketData");
        switch (RemoteEventFactory$WhenMappings.$EnumSwitchMapping$0[socketData.getCommandId().ordinal()]) {
            case 1: {
                remoteEvent = RemoteEvent.Created.INSTANCE;
                break;
            }
            case 2: {
                remoteEvent = RemoteEvent.Deactivate.INSTANCE;
                break;
            }
            case 3: {
                byte[] byArray = socketData.getPayload();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                ConfigAndroid configAndroid = ConfigAndroid.parseFrom((byte[])byArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)configAndroid, (String)"ConfigAndroid.parseFrom(socketData.payload!!)");
                remoteEvent = new RemoteEvent.ConfigurationsChanged(ConfigurationsFactory.INSTANCE.createConfigurations(configAndroid));
                break;
            }
            case 4: {
                byte[] byArray = socketData.getPayload();
                if (byArray == null) {
                    Intrinsics.throwNpe();
                }
                SafeZones safeZones = SafeZones.parseFrom((byte[])byArray);
                Intrinsics.checkExpressionValueIsNotNull((Object)safeZones, (String)"SafeZones.parseFrom(socketData.payload!!)");
                remoteEvent = new RemoteEvent.ZoneChanged(ZonesFactory.INSTANCE.createZones(safeZones));
                break;
            }
            case 5: {
                throw (Throwable)new GeoException.InvalidSocketEvent(socketData.getCommandId());
            }
            case 6: {
                remoteEvent = RemoteEvent.RealtimeBegin.INSTANCE;
                break;
            }
            case 7: {
                remoteEvent = RemoteEvent.RealtimeEnd.INSTANCE;
                break;
            }
            case 8: {
                remoteEvent = RemoteEvent.Request.INSTANCE;
                break;
            }
            case 9: {
                remoteEvent = RemoteEvent.ReRequest.INSTANCE;
                break;
            }
            case 10: {
                throw (Throwable)new GeoException.InvalidSocketEvent(socketData.getCommandId());
            }
            case 11: {
                throw (Throwable)new GeoException.InvalidSocketEvent(socketData.getCommandId());
            }
            case 12: {
                throw (Throwable)new GeoException.InvalidSocketEvent(socketData.getCommandId());
            }
            case 13: {
                throw (Throwable)new GeoException.InvalidSocketEvent(socketData.getCommandId());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return remoteEvent;
    }

    private RemoteEventFactory() {
    }

    static {
        RemoteEventFactory remoteEventFactory;
        INSTANCE = remoteEventFactory = new RemoteEventFactory();
    }
}

