/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.location;

import android.content.Context;
import android.os.Build;
import android.os.HandlerThread;
import com.huawei.hmf.tasks.Task;
import com.huawei.hmf.tasks.Tasks;
import com.huawei.hms.location.FusedLocationProviderClient;
import com.huawei.hms.location.LocationServices;
import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.ManufactureUtil;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.model.Location;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.repository.live.location.LocationEvent;
import org.findmykids.geo.data.repository.live.location.LocationRepository;
import org.findmykids.geo.data.repository.live.location.LocationRepositoryImpl;
import org.findmykids.geo.data.repository.live.location.LocationSourceProvider;
import org.findmykids.geo.data.repository.live.location.LocationSourceProviderGoogleFusedImpl;
import org.findmykids.geo.data.repository.live.location.LocationSourceProviderGpsProviderImpl;
import org.findmykids.geo.data.repository.live.location.LocationSourceProviderHuaweiFusedImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000*\u0001\f\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0017\u001a\u00020\u0011H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/findmykids/geo/data/repository/live/location/LocationRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/location/LocationRepository;", "mContext", "Landroid/content/Context;", "mLocalPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "(Landroid/content/Context;Lorg/findmykids/geo/data/preferences/LocalPreferences;)V", "mDisposable", "Lio/reactivex/disposables/Disposable;", "mIndex", "", "mLocationCallback", "org/findmykids/geo/data/repository/live/location/LocationRepositoryImpl$mLocationCallback$1", "Lorg/findmykids/geo/data/repository/live/location/LocationRepositoryImpl$mLocationCallback$1;", "mLocationSourceProvider", "Lorg/findmykids/geo/data/repository/live/location/LocationSourceProvider;", "restart", "", "configuration", "Lorg/findmykids/geo/data/model/Configuration$LocationDataConfiguration;", "handlerThread", "Landroid/os/HandlerThread;", "start", "stop", "toString", "", "geo_release"})
public final class LocationRepositoryImpl
extends LocationRepository {
    private Disposable mDisposable;
    private long mIndex;
    private mLocationCallback.1 mLocationCallback;
    private LocationSourceProvider mLocationSourceProvider;
    private final Context mContext;
    private final LocalPreferences mLocalPreferences;

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    protected void start(@NotNull Configuration.LocationDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        Disposable disposable = this.mDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mDisposable = null;
        if (Build.VERSION.SDK_INT >= 23 && this.mContext.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.sendError(new GeoException.LocationNoPermission("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"));
            this.restart(configuration, handlerThread);
        } else {
            LocationSourceProvider locationSourceProvider;
            LocationRepositoryImpl locationRepositoryImpl = this;
            if (ManufactureUtil.INSTANCE.isHuawei() && ManufactureUtil.INSTANCE.isEmuiVersion9_1_1orAfter()) {
                Object client;
                LocationRepositoryImpl locationRepositoryImpl2 = locationRepositoryImpl;
                try {
                    locationRepositoryImpl = locationRepositoryImpl2;
                    FusedLocationProviderClient fusedLocationProviderClient = LocationServices.getFusedLocationProviderClient((Context)this.mContext);
                    if (fusedLocationProviderClient == null) {
                        Intrinsics.throwNpe();
                    }
                    client = fusedLocationProviderClient;
                    Tasks.await((Task)client.getLastLocation(), (long)10L, (TimeUnit)TimeUnit.SECONDS);
                    client = new LocationSourceProviderHuaweiFusedImpl(this.mContext, this.mLocationCallback, handlerThread);
                }
                catch (Exception exception) {
                    locationRepositoryImpl = locationRepositoryImpl2;
                    client = ManufactureUtil.INSTANCE.isPlayServicesAvailable(this.mContext) ? (LocationSourceProvider)new LocationSourceProviderGoogleFusedImpl(this.mContext, this.mLocationCallback, handlerThread) : (LocationSourceProvider)new LocationSourceProviderGpsProviderImpl(this.mContext, this.mLocationCallback, handlerThread);
                }
                locationSourceProvider = client;
            } else {
                locationSourceProvider = ManufactureUtil.INSTANCE.isPlayServicesAvailable(this.mContext) ? (LocationSourceProvider)new LocationSourceProviderGoogleFusedImpl(this.mContext, this.mLocationCallback, handlerThread) : (LocationSourceProvider)new LocationSourceProviderGpsProviderImpl(this.mContext, this.mLocationCallback, handlerThread);
            }
            locationRepositoryImpl.mLocationSourceProvider = locationSourceProvider;
            try {
                LocationSourceProvider locationSourceProvider2 = this.mLocationSourceProvider;
                if (locationSourceProvider2 != null) {
                    locationSourceProvider2.start(configuration);
                }
            }
            catch (GeoException e) {
                this.sendError(e);
                this.restart(configuration, handlerThread);
            }
        }
    }

    @Override
    protected void stop() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        if (this.mDisposable == null) {
            try {
                LocationSourceProvider locationSourceProvider = this.mLocationSourceProvider;
                if (locationSourceProvider != null) {
                    locationSourceProvider.stop();
                }
            }
            catch (GeoException e) {
                this.sendError(e);
            }
            this.mLocationSourceProvider = null;
        } else {
            Disposable disposable = this.mDisposable;
            if (disposable != null) {
                disposable.dispose();
            }
            this.mDisposable = null;
        }
    }

    private final void restart(Configuration.LocationDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mDisposable = Completable.timer((long)configuration.getRestartDelay(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe(new Action(this, configuration, handlerThread){
            final /* synthetic */ LocationRepositoryImpl this$0;
            final /* synthetic */ Configuration.LocationDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                Logger.INSTANCE.d("restart").with(this.this$0).print();
                LocationRepositoryImpl.access$setMDisposable$p(this.this$0, null);
                if (LocationRepositoryImpl.access$isStarted(this.this$0)) {
                    this.this$0.start(this.$configuration, this.$handlerThread);
                }
            }
            {
                this.this$0 = locationRepositoryImpl;
                this.$configuration = locationDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ LocationRepositoryImpl this$0;
            final /* synthetic */ Configuration.LocationDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                LocationRepositoryImpl.access$setMDisposable$p(this.this$0, null);
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                LocationRepositoryImpl.access$sendError(this.this$0, new GeoException.LocationRestart(throwable));
                LocationRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = locationRepositoryImpl;
                this.$configuration = locationDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    @Inject
    public LocationRepositoryImpl(@NotNull Context mContext, @NotNull LocalPreferences mLocalPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        Intrinsics.checkParameterIsNotNull((Object)mLocalPreferences, (String)"mLocalPreferences");
        this.mContext = mContext;
        this.mLocalPreferences = mLocalPreferences;
        this.mIndex = 1L;
        this.mLocationCallback = new LocationSourceProvider.Callback(this){
            final /* synthetic */ LocationRepositoryImpl this$0;

            public void onLocation(@NotNull Location location) {
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg(location).print();
                LocationRepositoryImpl locationRepositoryImpl = this.this$0;
                long l = LocationRepositoryImpl.access$getMIndex$p(locationRepositoryImpl);
                LocationRepositoryImpl.access$setMIndex$p(locationRepositoryImpl, l + 1L);
                LocationRepositoryImpl.access$sendEvent(this.this$0, new LocationEvent(location, l, LocationRepositoryImpl.access$getMLocalPreferences$p(this.this$0).getAndIncreaseDefineGlobalIndex()));
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public static final /* synthetic */ Disposable access$getMDisposable$p(LocationRepositoryImpl $this) {
        return $this.mDisposable;
    }

    public static final /* synthetic */ void access$setMDisposable$p(LocationRepositoryImpl $this, Disposable disposable) {
        $this.mDisposable = disposable;
    }

    public static final /* synthetic */ boolean access$isStarted(LocationRepositoryImpl $this) {
        return $this.isStarted();
    }

    public static final /* synthetic */ void access$sendError(LocationRepositoryImpl $this, GeoException geoException) {
        $this.sendError(geoException);
    }

    public static final /* synthetic */ void access$restart(LocationRepositoryImpl $this, Configuration.LocationDataConfiguration configuration, HandlerThread handlerThread) {
        $this.restart(configuration, handlerThread);
    }

    public static final /* synthetic */ void access$sendEvent(LocationRepositoryImpl $this, LocationEvent t) {
        $this.sendEvent(t);
    }

    public static final /* synthetic */ long access$getMIndex$p(LocationRepositoryImpl $this) {
        return $this.mIndex;
    }

    public static final /* synthetic */ void access$setMIndex$p(LocationRepositoryImpl $this, long l) {
        $this.mIndex = l;
    }

    public static final /* synthetic */ LocalPreferences access$getMLocalPreferences$p(LocationRepositoryImpl $this) {
        return $this.mLocalPreferences;
    }
}

