/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.repository.live.gps;

import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.core.content.ContextCompat;
import io.reactivex.Completable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.LocationManagerUtil;
import org.findmykids.geo.data.model.Configuration;
import org.findmykids.geo.data.repository.live.gps.GpsEvent;
import org.findmykids.geo.data.repository.live.gps.GpsInfoFactory;
import org.findmykids.geo.data.repository.live.gps.GpsRepository;
import org.findmykids.geo.data.repository.live.gps.GpsRepositoryImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u0017H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/findmykids/geo/data/repository/live/gps/GpsRepositoryImpl;", "Lorg/findmykids/geo/data/repository/live/gps/GpsRepository;", "mContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mDisposable", "Lio/reactivex/disposables/Disposable;", "mGnssStatusCallback", "Landroid/location/GnssStatus$Callback;", "getMGnssStatusCallback", "()Landroid/location/GnssStatus$Callback;", "mGnssStatusCallback$delegate", "Lkotlin/Lazy;", "mGpsStatusListener", "Landroid/location/GpsStatus$Listener;", "mGpsStatusListener$annotations", "()V", "getMGpsStatusListener", "()Landroid/location/GpsStatus$Listener;", "mGpsStatusListener$delegate", "mLocationManager", "Landroid/location/LocationManager;", "restart", "", "configuration", "Lorg/findmykids/geo/data/model/Configuration$GpsDataConfiguration;", "handlerThread", "Landroid/os/HandlerThread;", "start", "stop", "toString", "", "geo_release"})
public final class GpsRepositoryImpl
extends GpsRepository {
    private final LocationManager mLocationManager;
    private Disposable mDisposable;
    private final Lazy mGnssStatusCallback$delegate;
    private final Lazy mGpsStatusListener$delegate;
    private final Context mContext;

    private final GnssStatus.Callback getMGnssStatusCallback() {
        Lazy lazy = this.mGnssStatusCallback$delegate;
        GpsRepositoryImpl gpsRepositoryImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GnssStatus.Callback)lazy.getValue();
    }

    private static /* synthetic */ void mGpsStatusListener$annotations() {
    }

    private final GpsStatus.Listener getMGpsStatusListener() {
        Lazy lazy = this.mGpsStatusListener$delegate;
        GpsRepositoryImpl gpsRepositoryImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GpsStatus.Listener)lazy.getValue();
    }

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    protected void start(@NotNull Configuration.GpsDataConfiguration configuration, @NotNull HandlerThread handlerThread) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)handlerThread, (String)"handlerThread");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg(configuration).print();
        if (Build.VERSION.SDK_INT >= 23 && this.mContext.checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") != 0 && this.mContext.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            this.sendError(new GeoException.GpsNoPermission("android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"));
            this.restart(configuration, handlerThread);
        } else if (LocationManagerUtil.INSTANCE.isGpsEnabled(this.mLocationManager)) {
            Completable.fromCallable((Callable)new Callable<Object>(this, handlerThread){
                final /* synthetic */ GpsRepositoryImpl this$0;
                final /* synthetic */ HandlerThread $handlerThread;

                public final boolean call() {
                    return Build.VERSION.SDK_INT >= 24 ? GpsRepositoryImpl.access$getMLocationManager$p(this.this$0).registerGnssStatusCallback(GpsRepositoryImpl.access$getMGnssStatusCallback$p(this.this$0), new Handler(this.$handlerThread.getLooper())) : GpsRepositoryImpl.access$getMLocationManager$p(this.this$0).addGpsStatusListener(GpsRepositoryImpl.access$getMGpsStatusListener$p(this.this$0));
                }
                {
                    this.this$0 = gpsRepositoryImpl;
                    this.$handlerThread = handlerThread;
                }
            }).subscribeOn(AndroidSchedulers.mainThread()).subscribe();
        } else {
            this.sendError(new GeoException.GpsLocationManagerGpsIsNotEnabled());
            this.restart(configuration, handlerThread);
        }
    }

    @Override
    protected void stop() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).print();
        if (Build.VERSION.SDK_INT >= 24) {
            this.mLocationManager.unregisterGnssStatusCallback(this.getMGnssStatusCallback());
        } else {
            this.mLocationManager.removeGpsStatusListener(this.getMGpsStatusListener());
        }
        Disposable disposable = this.mDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        this.mDisposable = null;
    }

    private final void restart(Configuration.GpsDataConfiguration configuration, HandlerThread handlerThread) {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
        this.mDisposable = Completable.timer((long)configuration.getRestartDelay(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)Schedulers.newThread()).subscribe(new Action(this, configuration, handlerThread){
            final /* synthetic */ GpsRepositoryImpl this$0;
            final /* synthetic */ Configuration.GpsDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                GpsRepositoryImpl.access$setMDisposable$p(this.this$0, null);
                Logger.INSTANCE.d("restart").with(this.this$0).print();
                if (GpsRepositoryImpl.access$isStarted(this.this$0)) {
                    this.this$0.start(this.$configuration, this.$handlerThread);
                }
            }
            {
                this.this$0 = gpsRepositoryImpl;
                this.$configuration = gpsDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        }, (Consumer)new Consumer<Throwable>(this, configuration, handlerThread){
            final /* synthetic */ GpsRepositoryImpl this$0;
            final /* synthetic */ Configuration.GpsDataConfiguration $configuration;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void accept(Throwable it) {
                GpsRepositoryImpl.access$setMDisposable$p(this.this$0, null);
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                GpsRepositoryImpl.access$sendError(this.this$0, new GeoException.GpsRestart(throwable));
                GpsRepositoryImpl.access$restart(this.this$0, this.$configuration, this.$handlerThread);
            }
            {
                this.this$0 = gpsRepositoryImpl;
                this.$configuration = gpsDataConfiguration;
                this.$handlerThread = handlerThread;
            }
        });
    }

    @Inject
    public GpsRepositoryImpl(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.mContext = mContext;
        Object object = ContextCompat.getSystemService((Context)this.mContext, LocationManager.class);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ContextCompat.getSystemS\u2026ionManager::class.java)!!");
        this.mLocationManager = (LocationManager)object;
        this.mGnssStatusCallback$delegate = LazyKt.lazy((Function0)((Function0)new Function0<mGnssStatusCallback.1>(this){
            final /* synthetic */ GpsRepositoryImpl this$0;

            @NotNull
            public final mGnssStatusCallback.1 invoke() {
                return new GnssStatus.Callback(this){
                    final /* synthetic */ mGnssStatusCallback.2 this$0;

                    public void onSatelliteStatusChanged(@NotNull GnssStatus status) {
                        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
                        Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0.this$0).print();
                        GpsRepositoryImpl.access$sendEvent(this.this$0.this$0, new GpsEvent(GpsInfoFactory.INSTANCE.createFromGnssStatus(status)));
                    }
                    {
                        this.this$0 = $outer;
                    }
                };
            }
            {
                this.this$0 = gpsRepositoryImpl;
                super(0);
            }
        }));
        this.mGpsStatusListener$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GpsStatus.Listener>(this){
            final /* synthetic */ GpsRepositoryImpl this$0;

            @NotNull
            public final GpsStatus.Listener invoke() {
                return new GpsStatus.Listener(this){
                    final /* synthetic */ mGpsStatusListener.2 this$0;

                    public final void onGpsStatusChanged(int it) {
                        Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0.this$0).print();
                        if (Build.VERSION.SDK_INT < 23 || GpsRepositoryImpl.access$getMContext$p(this.this$0.this$0).checkSelfPermission("android.permission.ACCESS_COARSE_LOCATION") == 0 || GpsRepositoryImpl.access$getMContext$p(this.this$0.this$0).checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") == 0) {
                            GpsRepositoryImpl gpsRepositoryImpl = this.this$0.this$0;
                            GpsStatus gpsStatus = GpsRepositoryImpl.access$getMLocationManager$p(this.this$0.this$0).getGpsStatus(null);
                            if (gpsStatus == null) {
                                Intrinsics.throwNpe();
                            }
                            GpsRepositoryImpl.access$sendEvent(gpsRepositoryImpl, new GpsEvent(GpsInfoFactory.INSTANCE.createFromGpsStatus(gpsStatus)));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
            }
            {
                this.this$0 = gpsRepositoryImpl;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ LocationManager access$getMLocationManager$p(GpsRepositoryImpl $this) {
        return $this.mLocationManager;
    }

    public static final /* synthetic */ GnssStatus.Callback access$getMGnssStatusCallback$p(GpsRepositoryImpl $this) {
        return $this.getMGnssStatusCallback();
    }

    public static final /* synthetic */ GpsStatus.Listener access$getMGpsStatusListener$p(GpsRepositoryImpl $this) {
        return $this.getMGpsStatusListener();
    }

    public static final /* synthetic */ Disposable access$getMDisposable$p(GpsRepositoryImpl $this) {
        return $this.mDisposable;
    }

    public static final /* synthetic */ void access$setMDisposable$p(GpsRepositoryImpl $this, Disposable disposable) {
        $this.mDisposable = disposable;
    }

    public static final /* synthetic */ boolean access$isStarted(GpsRepositoryImpl $this) {
        return $this.isStarted();
    }

    public static final /* synthetic */ void access$sendError(GpsRepositoryImpl $this, GeoException geoException) {
        $this.sendError(geoException);
    }

    public static final /* synthetic */ void access$restart(GpsRepositoryImpl $this, Configuration.GpsDataConfiguration configuration, HandlerThread handlerThread) {
        $this.restart(configuration, handlerThread);
    }

    public static final /* synthetic */ void access$sendEvent(GpsRepositoryImpl $this, GpsEvent t) {
        $this.sendEvent(t);
    }

    public static final /* synthetic */ Context access$getMContext$p(GpsRepositoryImpl $this) {
        return $this.mContext;
    }
}

