/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.network.factory;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.MessageLite;
import geoproto.Coord;
import geoproto.Extension;
import geoproto.FailureReason;
import geoproto.FailureReasonCode;
import geoproto.Gps;
import geoproto.Lbs;
import geoproto.Location;
import geoproto.Provider;
import geoproto.Reason;
import geoproto.Wifi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo._todo.Geo;
import org.findmykids.geo.api.extensions.GeoExtensions;
import org.findmykids.geo.data.model.Activity;
import org.findmykids.geo.data.model.ActivityType;
import org.findmykids.geo.data.model.Battery;
import org.findmykids.geo.data.model.CalculatedLocation;
import org.findmykids.geo.data.model.CommandType;
import org.findmykids.geo.data.model.Error;
import org.findmykids.geo.data.model.GpsInfo;
import org.findmykids.geo.data.model.LocatorLocation;
import org.findmykids.geo.data.model.SendGeoLocation;
import org.findmykids.geo.data.model.Session;
import org.findmykids.geo.data.model.WifiFull;
import org.findmykids.geo.data.network.factory.CoordFactory$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001c\u001a\u00020\u001d*\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0016\u0010 \u001a\u00020\u001d*\u00020\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u001c\u0010#\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010$\u001a\u00020\u001d*\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0014\u0010'\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010*\u001a\u00020\u001d*\u00020\u001dH\u0002J\u0014\u0010+\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010,\u001a\u00020-H\u0002J\u0014\u0010.\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\u0016\u00101\u001a\u00020\u001d*\u00020\u001d2\b\u00102\u001a\u0004\u0018\u000103H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/findmykids/geo/data/network/factory/CoordFactory;", "", "()V", "COMMANDS", "", "DEFINE_INDEX", "EMPTY_BATTERY_LEVEL_VALUE", "", "ERROR", "SEND_INDEX", "SEND_REASON", "SEND_TIME", "SESSION_INDEX", "SESSION_START", "TS_PATTERN", "createCoord", "Lgeoproto/Coord;", "geo", "Lorg/findmykids/geo/_todo/Geo$LbsLocatorErrorGeo;", "Lorg/findmykids/geo/_todo/Geo$LbsLocatorLocationGeo;", "Lorg/findmykids/geo/_todo/Geo$WifiLocatorErrorGeo;", "Lorg/findmykids/geo/_todo/Geo$WifiLocatorLocationGeo;", "error", "Lorg/findmykids/geo/data/model/Error;", "sendGeoLocation", "Lorg/findmykids/geo/data/model/SendGeoLocation;", "geoExtensions", "Lorg/findmykids/geo/api/extensions/GeoExtensions;", "setActivity", "Lgeoproto/Coord$Builder;", "activity", "Lorg/findmykids/geo/data/model/Activity;", "setBattery", "battery", "Lorg/findmykids/geo/data/model/Battery;", "setExtensions", "setGps", "gpsInfo", "Lorg/findmykids/geo/data/model/GpsInfo;", "setLocation", "location", "Lorg/findmykids/geo/data/model/Location;", "setOk", "setReason", "session", "Lorg/findmykids/geo/data/model/Session;", "setTs", "date", "Ljava/util/Date;", "setWifi", "wifi", "Lorg/findmykids/geo/data/model/Wifi;", "geo_release"})
public final class CoordFactory {
    private static final String TS_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZZZZZ";
    private static final String SESSION_INDEX = "session_index";
    private static final String DEFINE_INDEX = "define_index";
    private static final String SEND_INDEX = "send_index";
    private static final String SESSION_START = "session_start";
    private static final String SEND_TIME = "send_time";
    private static final String COMMANDS = "commands";
    private static final String SEND_REASON = "send_reason";
    private static final String ERROR = "error";
    private static final int EMPTY_BATTERY_LEVEL_VALUE = -1;
    public static final CoordFactory INSTANCE;

    @NotNull
    public final Coord createCoord(@NotNull Geo.LbsLocatorLocationGeo geo) {
        Coord.Builder builder;
        int n;
        int n2;
        Coord.Builder builder2;
        Intrinsics.checkParameterIsNotNull((Object)geo, (String)"geo");
        Coord.Builder builder3 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        boolean bl = false;
        boolean bl2 = false;
        Coord.Builder $this$apply = builder3;
        boolean bl3 = false;
        Object object = geo.getLocatorLocation();
        boolean bl4 = false;
        boolean bl5 = false;
        LocatorLocation location = object;
        boolean bl6 = false;
        $this$apply.addLocations(Location.newBuilder().setProvider(Provider.YANDEX).setLatitude(location.getLatitude()).setLongitude(location.getLongitude()).setAccuracy((long)location.getAccuracy()).setAge(System.currentTimeMillis() - location.getTime()).setAltitude((float)location.getAltitude()).build());
        Iterable $this$forEach$iv = geo.getLbsList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            org.findmykids.geo.data.model.Lbs it = (org.findmykids.geo.data.model.Lbs)element$iv;
            boolean bl7 = false;
            $this$apply.addLbs(Lbs.newBuilder().setCountryCode(it.getCountryCode()).setOperatorId(it.getOperatorId()).setCellId(it.getCellId()).setLac(it.getLac()).setSignalStrength(it.getLevel()).build());
        }
        $this$forEach$iv = geo.getWifiFullList();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WifiFull it = (WifiFull)element$iv;
            boolean bl8 = false;
            $this$apply.addWifi(Wifi.newBuilder().setMac(it.getBssid()).setSignalStrength(it.getLevel()).setState(it.isConnected()).setName(it.getSsid()).build());
        }
        $this$apply.setActivityType(geoproto.Activity.UNKNOWN);
        if (geo.getExtensions().containsKey("isCharging")) {
            String string2 = geo.getExtensions().get("isCharging");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            object = string2;
            builder2 = $this$apply;
            bl4 = false;
            n2 = Boolean.parseBoolean((String)object);
            builder2.setIsCharging(n2 != 0);
        }
        Coord.Builder builder4 = $this$apply;
        if (geo.getExtensions().containsKey("level")) {
            String string3 = geo.getExtensions().get("level");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            object = string3;
            builder2 = builder4;
            bl4 = false;
            n2 = Integer.parseInt((String)object);
            builder4 = builder2;
            n = n2;
        } else {
            n = -1;
        }
        builder4.setBatteryLevel(n);
        object = new JsonObject();
        builder2 = $this$apply;
        bl4 = false;
        boolean bl9 = false;
        Object $this$apply2 = object;
        boolean bl10 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)geo.getSession().getIndex());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(geo.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(new Date()));
        JsonArray jsonArray = new JsonArray();
        String string4 = COMMANDS;
        Object object2 = $this$apply2;
        boolean bl11 = false;
        boolean bl12 = false;
        JsonArray reasons = jsonArray;
        boolean bl13 = false;
        Iterable $this$forEach$iv2 = geo.getSession().getCommandsTypes();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CommandType it = (CommandType)((Object)element$iv);
            boolean bl14 = false;
            reasons.add((Number)it.getValue());
        }
        JsonArray jsonArray2 = jsonArray;
        object2.add(string4, (JsonElement)jsonArray2);
        Object object3 = object;
        builder2.setDebug(object3.toString());
        Coord.Builder builder5 = builder = builder3;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory3.setReason(coordFactory2.setTs(coordFactory.setOk(builder5), geo.getCreate()), geo.getSession()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026session)\n        .build()");
        return coord;
    }

    @NotNull
    public final Coord createCoord(@NotNull Geo.LbsLocatorErrorGeo geo) {
        Coord.Builder builder;
        int n;
        int n2;
        boolean bl;
        Coord.Builder builder2;
        String string2;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)geo, (String)"geo");
        Coord.Builder builder3 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        boolean bl2 = false;
        boolean bl3 = false;
        Coord.Builder $this$apply = builder3;
        boolean bl4 = false;
        Iterable $this$forEach$iv = geo.getLbsList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (org.findmykids.geo.data.model.Lbs)element$iv;
            boolean bl5 = false;
            $this$apply.addLbs(Lbs.newBuilder().setCountryCode(((org.findmykids.geo.data.model.Lbs)it).getCountryCode()).setOperatorId(((org.findmykids.geo.data.model.Lbs)it).getOperatorId()).setCellId(((org.findmykids.geo.data.model.Lbs)it).getCellId()).setLac(((org.findmykids.geo.data.model.Lbs)it).getLac()).setSignalStrength(((org.findmykids.geo.data.model.Lbs)it).getLevel()).build());
        }
        $this$forEach$iv = geo.getWifiFullList();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WifiFull)element$iv;
            boolean bl6 = false;
            $this$apply.addWifi(Wifi.newBuilder().setMac(((WifiFull)it).getBssid()).setSignalStrength(((WifiFull)it).getLevel()).setState(((WifiFull)it).isConnected()).setName(((WifiFull)it).getSsid()).build());
        }
        $this$apply.setActivityType(geoproto.Activity.UNKNOWN);
        if (geo.getExtensions().containsKey("isCharging")) {
            String string3 = geo.getExtensions().get("isCharging");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string2 = string3;
            builder2 = $this$apply;
            bl = false;
            n2 = Boolean.parseBoolean(string2);
            builder2.setIsCharging(n2 != 0);
        }
        Coord.Builder builder4 = $this$apply;
        if (geo.getExtensions().containsKey("level")) {
            String string4 = geo.getExtensions().get("level");
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            string2 = string4;
            builder2 = builder4;
            bl = false;
            n2 = Integer.parseInt(string2);
            builder4 = builder2;
            n = n2;
        } else {
            n = -1;
        }
        builder4.setBatteryLevel(n);
        string2 = new JsonObject();
        builder2 = $this$apply;
        bl = false;
        boolean bl7 = false;
        String $this$apply2 = string2;
        boolean bl8 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)geo.getSession().getIndex());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(geo.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(new Date()));
        JsonArray jsonArray = new JsonArray();
        String string5 = COMMANDS;
        String string6 = $this$apply2;
        boolean bl9 = false;
        boolean bl10 = false;
        JsonArray reasons = jsonArray;
        boolean bl11 = false;
        Iterable $this$forEach$iv2 = geo.getSession().getCommandsTypes();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CommandType it2 = (CommandType)((Object)element$iv);
            boolean bl12 = false;
            reasons.add((Number)it2.getValue());
        }
        JsonArray jsonArray2 = jsonArray;
        string6.add(string5, (JsonElement)jsonArray2);
        String string7 = string2;
        builder2.setDebug(string7.toString());
        Coord.Builder builder5 = builder = builder3;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory3.setReason(coordFactory2.setTs(coordFactory.setOk(builder5), geo.getCreate()), geo.getSession()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026session)\n        .build()");
        return coord;
    }

    @NotNull
    public final Coord createCoord(@NotNull Geo.WifiLocatorLocationGeo geo) {
        Coord.Builder builder;
        int n;
        int n2;
        Coord.Builder builder2;
        Intrinsics.checkParameterIsNotNull((Object)geo, (String)"geo");
        Coord.Builder builder3 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        boolean bl = false;
        boolean bl2 = false;
        Coord.Builder $this$apply = builder3;
        boolean bl3 = false;
        Object object = geo.getLocatorLocation();
        boolean bl4 = false;
        boolean bl5 = false;
        LocatorLocation location = object;
        boolean bl6 = false;
        $this$apply.addLocations(Location.newBuilder().setProvider(Provider.YANDEX).setLatitude(location.getLatitude()).setLongitude(location.getLongitude()).setAccuracy((long)location.getAccuracy()).setAge(System.currentTimeMillis() - location.getTime()).setAltitude((float)location.getAltitude()).build());
        Iterable $this$forEach$iv = geo.getWifiFullList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WifiFull it = (WifiFull)element$iv;
            boolean bl7 = false;
            $this$apply.addWifi(Wifi.newBuilder().setMac(it.getBssid()).setSignalStrength(it.getLevel()).setState(it.isConnected()).setName(it.getSsid()).build());
        }
        $this$forEach$iv = geo.getLbsList();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            org.findmykids.geo.data.model.Lbs it = (org.findmykids.geo.data.model.Lbs)element$iv;
            boolean bl8 = false;
            $this$apply.addLbs(Lbs.newBuilder().setCountryCode(it.getCountryCode()).setOperatorId(it.getOperatorId()).setCellId(it.getCellId()).setLac(it.getLac()).setSignalStrength(it.getLevel()).build());
        }
        $this$apply.setActivityType(geoproto.Activity.UNKNOWN);
        if (geo.getExtensions().containsKey("isCharging")) {
            String string2 = geo.getExtensions().get("isCharging");
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            object = string2;
            builder2 = $this$apply;
            bl4 = false;
            n2 = Boolean.parseBoolean((String)object);
            builder2.setIsCharging(n2 != 0);
        }
        Coord.Builder builder4 = $this$apply;
        if (geo.getExtensions().containsKey("level")) {
            String string3 = geo.getExtensions().get("level");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            object = string3;
            builder2 = builder4;
            bl4 = false;
            n2 = Integer.parseInt((String)object);
            builder4 = builder2;
            n = n2;
        } else {
            n = -1;
        }
        builder4.setBatteryLevel(n);
        object = new JsonObject();
        builder2 = $this$apply;
        bl4 = false;
        boolean bl9 = false;
        Object $this$apply2 = object;
        boolean bl10 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)geo.getSession().getIndex());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(geo.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(new Date()));
        JsonArray jsonArray = new JsonArray();
        String string4 = COMMANDS;
        Object object2 = $this$apply2;
        boolean bl11 = false;
        boolean bl12 = false;
        JsonArray reasons = jsonArray;
        boolean bl13 = false;
        Iterable $this$forEach$iv2 = geo.getSession().getCommandsTypes();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CommandType it = (CommandType)((Object)element$iv);
            boolean bl14 = false;
            reasons.add((Number)it.getValue());
        }
        JsonArray jsonArray2 = jsonArray;
        object2.add(string4, (JsonElement)jsonArray2);
        Object object3 = object;
        builder2.setDebug(object3.toString());
        Coord.Builder builder5 = builder = builder3;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory3.setReason(coordFactory2.setTs(coordFactory.setOk(builder5), geo.getCreate()), geo.getSession()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026session)\n        .build()");
        return coord;
    }

    @NotNull
    public final Coord createCoord(@NotNull Geo.WifiLocatorErrorGeo geo) {
        Coord.Builder builder;
        int n;
        int n2;
        boolean bl;
        Coord.Builder builder2;
        String string2;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)geo, (String)"geo");
        Coord.Builder builder3 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        boolean bl2 = false;
        boolean bl3 = false;
        Coord.Builder $this$apply = builder3;
        boolean bl4 = false;
        Iterable $this$forEach$iv = geo.getWifiFullList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (WifiFull)element$iv;
            boolean bl5 = false;
            $this$apply.addWifi(Wifi.newBuilder().setMac(((WifiFull)it).getBssid()).setSignalStrength(((WifiFull)it).getLevel()).setState(((WifiFull)it).isConnected()).setName(((WifiFull)it).getSsid()).build());
        }
        $this$forEach$iv = geo.getLbsList();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (org.findmykids.geo.data.model.Lbs)element$iv;
            boolean bl6 = false;
            $this$apply.addLbs(Lbs.newBuilder().setCountryCode(((org.findmykids.geo.data.model.Lbs)it).getCountryCode()).setOperatorId(((org.findmykids.geo.data.model.Lbs)it).getOperatorId()).setCellId(((org.findmykids.geo.data.model.Lbs)it).getCellId()).setLac(((org.findmykids.geo.data.model.Lbs)it).getLac()).setSignalStrength(((org.findmykids.geo.data.model.Lbs)it).getLevel()).build());
        }
        $this$apply.setActivityType(geoproto.Activity.UNKNOWN);
        if (geo.getExtensions().containsKey("isCharging")) {
            String string3 = geo.getExtensions().get("isCharging");
            if (string3 == null) {
                Intrinsics.throwNpe();
            }
            string2 = string3;
            builder2 = $this$apply;
            bl = false;
            n2 = Boolean.parseBoolean(string2);
            builder2.setIsCharging(n2 != 0);
        }
        Coord.Builder builder4 = $this$apply;
        if (geo.getExtensions().containsKey("level")) {
            String string4 = geo.getExtensions().get("level");
            if (string4 == null) {
                Intrinsics.throwNpe();
            }
            string2 = string4;
            builder2 = builder4;
            bl = false;
            n2 = Integer.parseInt(string2);
            builder4 = builder2;
            n = n2;
        } else {
            n = -1;
        }
        builder4.setBatteryLevel(n);
        string2 = new JsonObject();
        builder2 = $this$apply;
        bl = false;
        boolean bl7 = false;
        String $this$apply2 = string2;
        boolean bl8 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)geo.getSession().getIndex());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(geo.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(new Date()));
        JsonArray jsonArray = new JsonArray();
        String string5 = COMMANDS;
        String string6 = $this$apply2;
        boolean bl9 = false;
        boolean bl10 = false;
        JsonArray reasons = jsonArray;
        boolean bl11 = false;
        Iterable $this$forEach$iv2 = geo.getSession().getCommandsTypes();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CommandType it2 = (CommandType)((Object)element$iv);
            boolean bl12 = false;
            reasons.add((Number)it2.getValue());
        }
        JsonArray jsonArray2 = jsonArray;
        string6.add(string5, (JsonElement)jsonArray2);
        String string7 = string2;
        builder2.setDebug(string7.toString());
        Coord.Builder builder5 = builder = builder3;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder5, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory3.setReason(coordFactory2.setTs(coordFactory.setOk(builder5), geo.getCreate()), geo.getSession()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026session)\n        .build()");
        return coord;
    }

    @NotNull
    public final Coord createCoord(@NotNull Error error) {
        Coord.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)error, (String)ERROR);
        Coord.Builder builder2 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        CoordFactory coordFactory4 = this;
        boolean bl = false;
        boolean bl2 = false;
        Coord.Builder $this$apply = builder2;
        boolean bl3 = false;
        $this$apply.setFailureReason(FailureReason.newBuilder().setCode(FailureReasonCode.EMPTY).setDescription(error.getText()).build());
        JsonObject jsonObject = new JsonObject();
        Coord.Builder builder3 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        JsonObject $this$apply2 = jsonObject;
        boolean bl6 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)error.getSession().getIndex());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(error.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(new Date()));
        JsonArray jsonArray = new JsonArray();
        String string2 = COMMANDS;
        JsonObject jsonObject2 = $this$apply2;
        boolean bl7 = false;
        boolean bl8 = false;
        JsonArray reasons = jsonArray;
        boolean bl9 = false;
        Iterable $this$forEach$iv = error.getSession().getCommandsTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandType it = (CommandType)((Object)element$iv);
            boolean bl10 = false;
            reasons.add((Number)it.getValue());
        }
        JsonArray jsonArray2 = jsonArray;
        jsonObject2.add(string2, (JsonElement)jsonArray2);
        $this$apply2.addProperty(ERROR, error.getText());
        JsonObject jsonObject3 = jsonObject;
        builder3.setDebug(jsonObject3.toString());
        Coord.Builder builder4 = builder = builder2;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder4, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory4.setReason(coordFactory3.setBattery(coordFactory2.setActivity(coordFactory.setTs(builder4, error.getCreate()), error.getActivity()), error.getBattery()), error.getSession()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026session)\n        .build()");
        return coord;
    }

    @NotNull
    public final Coord createCoord(@NotNull SendGeoLocation sendGeoLocation2, @NotNull GeoExtensions geoExtensions) {
        Coord.Builder builder;
        Intrinsics.checkParameterIsNotNull((Object)sendGeoLocation2, (String)"sendGeoLocation");
        Intrinsics.checkParameterIsNotNull((Object)geoExtensions, (String)"geoExtensions");
        Coord.Builder builder2 = Coord.newBuilder();
        CoordFactory coordFactory = this;
        CoordFactory coordFactory2 = this;
        CoordFactory coordFactory3 = this;
        CoordFactory coordFactory4 = this;
        CoordFactory coordFactory5 = this;
        CoordFactory coordFactory6 = this;
        CoordFactory coordFactory7 = this;
        CoordFactory coordFactory8 = this;
        CoordFactory coordFactory9 = this;
        boolean bl = false;
        boolean bl2 = false;
        Coord.Builder $this$apply = builder2;
        boolean bl3 = false;
        JsonObject jsonObject = new JsonObject();
        Coord.Builder builder3 = $this$apply;
        boolean bl4 = false;
        boolean bl5 = false;
        JsonObject $this$apply2 = jsonObject;
        boolean bl6 = false;
        $this$apply2.addProperty(SESSION_INDEX, (Number)sendGeoLocation2.getSession().getIndex());
        $this$apply2.addProperty(DEFINE_INDEX, "" + sendGeoLocation2.getLocationDefineSessionIndex() + '/' + sendGeoLocation2.getLocationDefineGlobalIndex());
        $this$apply2.addProperty(SEND_INDEX, "" + sendGeoLocation2.getSendSessionIndex() + '/' + sendGeoLocation2.getSendGlobalIndex());
        $this$apply2.addProperty(SEND_REASON, sendGeoLocation2.getSendReason());
        $this$apply2.addProperty(SESSION_START, new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(sendGeoLocation2.getSession().getCreate()));
        $this$apply2.addProperty(SEND_TIME, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSZZZZZ", Locale.ENGLISH).format(new Date()));
        Object object = new JsonArray();
        String string2 = COMMANDS;
        JsonObject jsonObject2 = $this$apply2;
        boolean bl7 = false;
        boolean bl8 = false;
        JsonArray reasons = object;
        boolean bl9 = false;
        Iterable $this$forEach$iv = sendGeoLocation2.getSession().getCommandsTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandType it = (CommandType)((Object)element$iv);
            boolean bl10 = false;
            reasons.add((Number)it.getValue());
        }
        JsonArray jsonArray = object;
        jsonObject2.add(string2, (JsonElement)jsonArray);
        CalculatedLocation calculatedLocation = sendGeoLocation2.getCalculatedLocation();
        if (calculatedLocation != null) {
            object = calculatedLocation;
            bl7 = false;
            bl8 = false;
            Object calculatedLocation2 = object;
            boolean bl11 = false;
            JsonObject jsonObject3 = new JsonObject();
            String string3 = "kalman";
            JsonObject jsonObject4 = $this$apply2;
            boolean bl12 = false;
            boolean bl13 = false;
            JsonObject $this$apply3 = jsonObject3;
            boolean bl14 = false;
            $this$apply3.addProperty("latitude", (Number)((CalculatedLocation)calculatedLocation2).getLatitude());
            $this$apply3.addProperty("longitude", (Number)((CalculatedLocation)calculatedLocation2).getLongitude());
            $this$apply3.addProperty("speed", (Number)((CalculatedLocation)calculatedLocation2).getSpeed());
            $this$apply3.addProperty("altitude", (Number)((CalculatedLocation)calculatedLocation2).getAltitude());
            JsonObject jsonObject5 = jsonObject3;
            jsonObject4.add(string3, (JsonElement)jsonObject5);
        }
        JsonObject jsonObject6 = jsonObject;
        builder3.setDebug(jsonObject6.toString());
        Coord.Builder builder4 = builder = builder2;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder4, (String)"Coord\n        .newBuilde\u2026   }.toString()\n        }");
        Coord coord = coordFactory9.setExtensions(coordFactory8.setReason(coordFactory7.setWifi(coordFactory6.setGps(coordFactory5.setActivity(coordFactory4.setBattery(coordFactory3.setLocation(coordFactory2.setTs(coordFactory.setOk(builder4), sendGeoLocation2.getCreate()), sendGeoLocation2.getLocation()), sendGeoLocation2.getBattery()), sendGeoLocation2.getActivity()), sendGeoLocation2.getGpsInfo()), sendGeoLocation2.getWifi()), sendGeoLocation2.getSession()), sendGeoLocation2, geoExtensions).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)coord, (String)"Coord\n        .newBuilde\u2026ensions)\n        .build()");
        return coord;
    }

    private final Coord.Builder setTs(@NotNull Coord.Builder $this$setTs, Date date) {
        $this$setTs.setTs(new SimpleDateFormat(TS_PATTERN, Locale.ENGLISH).format(date));
        return $this$setTs;
    }

    private final Coord.Builder setOk(@NotNull Coord.Builder $this$setOk) {
        $this$setOk.setFailureReason(FailureReason.newBuilder().setCode(FailureReasonCode.OK).build());
        return $this$setOk;
    }

    private final Coord.Builder setLocation(@NotNull Coord.Builder $this$setLocation, org.findmykids.geo.data.model.Location location) {
        Location.Builder builder;
        boolean bl;
        boolean bl2;
        Number number;
        Provider provider;
        Location.Builder builder2 = Location.newBuilder();
        switch (CoordFactory$WhenMappings.$EnumSwitchMapping$0[location.getSource().ordinal()]) {
            case 1: {
                provider = Provider.FUSED;
                break;
            }
            case 2: {
                provider = Provider.FUSED;
                break;
            }
            case 3: {
                provider = Provider.GPS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Long l = location.getElapsedRealtimeNanos();
        Location.Builder builder3 = builder2.setProvider(provider).setLatitude(location.getLatitude()).setLongitude(location.getLongitude()).setAge(System.currentTimeMillis() - (l != null ? l.longValue() : location.getTime()));
        Coord.Builder builder4 = $this$setLocation;
        boolean bl3 = false;
        boolean bl4 = false;
        Location.Builder $this$apply = builder3;
        boolean bl5 = false;
        Float f = location.getAccuracy();
        if (f != null) {
            number = f;
            bl2 = false;
            bl = false;
            float it = ((Number)number).floatValue();
            boolean bl6 = false;
            $this$apply.setAccuracy((long)it);
        }
        builder3 = builder = builder3;
        bl3 = false;
        bl4 = false;
        $this$apply = builder3;
        boolean bl7 = false;
        Double d = location.getAltitude();
        if (d != null) {
            number = d;
            bl2 = false;
            bl = false;
            double it = ((Number)number).doubleValue();
            boolean bl8 = false;
            $this$apply.setAltitude((float)it);
        }
        builder3 = builder = builder3;
        bl3 = false;
        bl4 = false;
        $this$apply = builder3;
        boolean bl9 = false;
        Float f2 = location.getSpeed();
        if (f2 != null) {
            number = f2;
            bl2 = false;
            bl = false;
            float it = ((Number)number).floatValue();
            boolean bl10 = false;
            $this$apply.setSpeed(it);
        }
        builder3 = builder = builder3;
        bl3 = false;
        bl4 = false;
        $this$apply = builder3;
        boolean bl11 = false;
        Float f3 = location.getBearing();
        if (f3 != null) {
            number = f3;
            bl2 = false;
            bl = false;
            float it = ((Number)number).floatValue();
            boolean bl12 = false;
            $this$apply.setCource((int)it);
        }
        builder = builder3;
        builder4.addLocations(builder.build());
        return $this$setLocation;
    }

    private final Coord.Builder setBattery(@NotNull Coord.Builder $this$setBattery, Battery battery) {
        if (battery == null) {
            $this$setBattery.setBatteryLevel(-1);
        } else {
            $this$setBattery.setIsCharging(battery.isCharging());
            $this$setBattery.setBatteryLevel(battery.getLevel());
        }
        return $this$setBattery;
    }

    private final Coord.Builder setGps(@NotNull Coord.Builder $this$setGps, GpsInfo gpsInfo) {
        block0: {
            GpsInfo gpsInfo2 = gpsInfo;
            if (gpsInfo2 == null) break block0;
            GpsInfo gpsInfo3 = gpsInfo2;
            boolean bl = false;
            boolean bl2 = false;
            GpsInfo it = gpsInfo3;
            boolean bl3 = false;
            $this$setGps.setGps(Gps.newBuilder().setTimeToFirstFix(gpsInfo.getTimeToFirstFix()).setTotalSatellitesCount(gpsInfo.getMaxSatellites()).setUsedSatellitesCount(gpsInfo.getUsedSatellitesCount()).setNotUsedSatellitesCount(gpsInfo.getMaxSatellites() - gpsInfo.getSatellites().size()).build());
        }
        return $this$setGps;
    }

    private final Coord.Builder setWifi(@NotNull Coord.Builder $this$setWifi, org.findmykids.geo.data.model.Wifi wifi) {
        block0: {
            org.findmykids.geo.data.model.Wifi wifi2 = wifi;
            if (wifi2 == null) break block0;
            org.findmykids.geo.data.model.Wifi wifi3 = wifi2;
            boolean bl = false;
            boolean bl2 = false;
            org.findmykids.geo.data.model.Wifi it = wifi3;
            boolean bl3 = false;
            $this$setWifi.addWifi(Wifi.newBuilder().setMac(it.getMac()).setSignalStrength(it.getLevel()).setState(true).setName(it.getSsid()).build());
        }
        return $this$setWifi;
    }

    private final Coord.Builder setReason(@NotNull Coord.Builder $this$setReason, Session session) {
        Reason reason;
        switch (CoordFactory$WhenMappings.$EnumSwitchMapping$1[((CommandType)((Object)CollectionsKt.first(session.getCommandsTypes()))).ordinal()]) {
            case 1: {
                reason = Reason.ACTIVATE;
                break;
            }
            case 2: {
                reason = Reason.DEACTIVATE;
                break;
            }
            case 3: {
                reason = Reason.PING;
                break;
            }
            case 4: {
                reason = Reason.REQUEST;
                break;
            }
            case 5: {
                reason = Reason.TIMER;
                break;
            }
            case 6: {
                reason = Reason.BOOT;
                break;
            }
            case 7: {
                reason = Reason.ACTIVITYTRANSITIONS;
                break;
            }
            case 8: {
                reason = Reason.ZONE;
                break;
            }
            case 9: {
                reason = Reason.STATION;
                break;
            }
            case 10: {
                reason = Reason.PASSIVE;
                break;
            }
            case 11: {
                reason = Reason.PING;
                break;
            }
            case 12: {
                reason = Reason.LOG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$setReason.setReason(reason);
        return $this$setReason;
    }

    /*
     * WARNING - void declaration
     */
    private final Coord.Builder setActivity(@NotNull Coord.Builder $this$setActivity, Activity activity2) {
        block17: {
            $this$setActivity.setActivityType(geoproto.Activity.UNKNOWN);
            Activity activity3 = activity2;
            if (activity3 == null) break block17;
            Activity activity4 = activity3;
            boolean bl = false;
            boolean bl2 = false;
            Activity it = activity4;
            boolean bl3 = false;
            Object object = it.getActivitiesWithConfidences();
            boolean bl4 = false;
            if (!object.isEmpty()) {
                geoproto.Activity activity5;
                void activityTypeValue;
                Object v1;
                Object object2 = it.getActivitiesWithConfidences();
                boolean bl5 = false;
                Iterable iterable = object2.entrySet();
                boolean bl6 = false;
                Iterator iterator = iterable.iterator();
                if (!iterator.hasNext()) {
                    v1 = null;
                } else {
                    Object t = iterator.next();
                    if (!iterator.hasNext()) {
                        v1 = t;
                    } else {
                        Map.Entry pair = (Map.Entry)t;
                        boolean bl7 = false;
                        int n = ((Number)pair.getValue()).intValue();
                        do {
                            Object t2 = iterator.next();
                            Map.Entry pair2 = (Map.Entry)t2;
                            $i$a$-maxBy-CoordFactory$setActivity$1$1 = false;
                            int n2 = ((Number)pair2.getValue()).intValue();
                            if (n >= n2) continue;
                            t = t2;
                            n = n2;
                        } while (iterator.hasNext());
                        v1 = t;
                    }
                }
                Map.Entry entry = v1;
                if (entry == null) {
                    Intrinsics.throwNpe();
                }
                Map.Entry entry2 = entry;
                object2 = entry2;
                bl5 = false;
                object = (ActivityType)((Object)object2.getKey());
                object2 = entry2;
                bl5 = false;
                int confidenceValue = ((Number)object2.getValue()).intValue();
                switch (CoordFactory$WhenMappings.$EnumSwitchMapping$2[activityTypeValue.ordinal()]) {
                    case 1: {
                        activity5 = geoproto.Activity.IN_VEHICLE;
                        break;
                    }
                    case 2: {
                        activity5 = geoproto.Activity.ON_BICYCLE;
                        break;
                    }
                    case 3: {
                        activity5 = geoproto.Activity.ON_FOOT;
                        break;
                    }
                    case 4: {
                        activity5 = geoproto.Activity.STILL;
                        break;
                    }
                    case 5: {
                        activity5 = geoproto.Activity.UNKNOWN;
                        break;
                    }
                    case 6: {
                        activity5 = geoproto.Activity.TILTING;
                        break;
                    }
                    case 7: {
                        activity5 = geoproto.Activity.WALKING;
                        break;
                    }
                    case 8: {
                        activity5 = geoproto.Activity.RUNNING;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                $this$setActivity.setActivityType(activity5);
                $this$setActivity.setConfidence(confidenceValue);
            }
        }
        return $this$setActivity;
    }

    /*
     * WARNING - void declaration
     */
    private final Coord.Builder setExtensions(@NotNull Coord.Builder $this$setExtensions, SendGeoLocation sendGeoLocation2, GeoExtensions geoExtensions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = geoExtensions.mapExtensions(sendGeoLocation2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MessageLite messageLite = (MessageLite)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Extension.Builder builder = Extension.newBuilder().setData(it.toByteString());
            Package package_ = it.getClass().getPackage();
            if (package_ == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"it.javaClass.`package`!!");
            Extension extension = builder.setName(package_.getName()).build();
            collection.add(extension);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Extension it = (Extension)element$iv;
            boolean bl = false;
            $this$setExtensions.addExtension(it);
        }
        return $this$setExtensions;
    }

    private CoordFactory() {
    }

    static {
        CoordFactory coordFactory;
        INSTANCE = coordFactory = new CoordFactory();
    }
}

