/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.network;

import android.os.Build;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.reactivex.ObservableEmitter;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.functions.Cancellable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.findmykids.geo.common.GeoException;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.network.SocketClient;
import org.findmykids.geo.data.network.SocketClientImpl;
import org.findmykids.geo.data.network.SocketClientImpl$WhenMappings;
import org.findmykids.geo.data.network.factory.SocketDataFactory;
import org.findmykids.geo.data.network.model.SocketCommand;
import org.findmykids.geo.data.network.model.SocketData;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 02\u00020\u00012\u00020\u00022\u00020\u0003:\u000201B\u0017\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\b\u0010\u0019\u001a\u00020\u0016H\u0002J \u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J \u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\"\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0007H\u0016J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0+2\u0006\u0010,\u001a\u00020\u000eH\u0016J\u0016\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\b\u0010/\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/findmykids/geo/data/network/SocketClientImpl;", "Lokhttp3/WebSocketListener;", "Lorg/findmykids/geo/data/network/SocketClient;", "Lio/reactivex/functions/Cancellable;", "mLocalPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "mAppVersion", "", "(Lorg/findmykids/geo/data/preferences/LocalPreferences;Ljava/lang/String;)V", "mConnectAfterDisconnecting", "", "mDisconnectAfterConnecting", "mEmitter", "Lio/reactivex/ObservableEmitter;", "Lorg/findmykids/geo/data/network/model/SocketData;", "mOkHttpClient", "Lokhttp3/OkHttpClient;", "mStatus", "Lorg/findmykids/geo/data/network/SocketClientImpl$Status;", "mWebSocket", "Lokhttp3/WebSocket;", "cancel", "", "connecting", "disconnecting", "nothing", "onClosed", "webSocket", "code", "", "reason", "onClosing", "onFailure", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "bytes", "Lokio/ByteString;", "onOpen", "send", "Lio/reactivex/Single;", "socketData", "subscribe", "emitter", "toString", "Companion", "Status", "geo_release"})
public final class SocketClientImpl
extends WebSocketListener
implements SocketClient,
Cancellable {
    private ObservableEmitter<SocketData> mEmitter;
    private volatile Status mStatus;
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebSocket;
    private volatile boolean mConnectAfterDisconnecting;
    private volatile boolean mDisconnectAfterConnecting;
    private final LocalPreferences mLocalPreferences;
    private final String mAppVersion;
    private static final int NORMAL_CLOSURE_STATUS = 1000;
    private static final String STOP_WORD = "goodbye";
    private static final String ERROR_FIELD = "error";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String toString() {
        return "";
    }

    public synchronized void subscribe(@NotNull ObservableEmitter<SocketData> emitter) {
        Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).print();
        this.mEmitter = emitter;
        this.mDisconnectAfterConnecting = false;
        switch (SocketClientImpl$WhenMappings.$EnumSwitchMapping$0[this.mStatus.ordinal()]) {
            case 1: {
                this.mConnectAfterDisconnecting = false;
                this.nothing();
                break;
            }
            case 2: {
                this.mConnectAfterDisconnecting = false;
                this.nothing();
                break;
            }
            case 3: {
                this.mConnectAfterDisconnecting = true;
                this.nothing();
                break;
            }
            case 4: {
                this.mConnectAfterDisconnecting = false;
                this.connecting();
                break;
            }
        }
        emitter.setCancellable((Cancellable)this);
    }

    public synchronized void cancel() {
        Logger.i$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).print();
        this.mEmitter = null;
        this.mConnectAfterDisconnecting = false;
        switch (SocketClientImpl$WhenMappings.$EnumSwitchMapping$1[this.mStatus.ordinal()]) {
            case 1: {
                this.mDisconnectAfterConnecting = false;
                this.disconnecting();
                break;
            }
            case 2: {
                this.mDisconnectAfterConnecting = true;
                this.nothing();
                break;
            }
            case 3: {
                this.mDisconnectAfterConnecting = false;
                this.nothing();
                break;
            }
            case 4: {
                this.mDisconnectAfterConnecting = false;
                this.nothing();
                break;
            }
        }
    }

    @Override
    @NotNull
    public Single<Boolean> send(@NotNull SocketData socketData) {
        Intrinsics.checkParameterIsNotNull((Object)socketData, (String)"socketData");
        Single single = Single.fromCallable((Callable)new Callable<T>(this, socketData){
            final /* synthetic */ SocketClientImpl this$0;
            final /* synthetic */ SocketData $socketData;

            public final boolean call() {
                boolean bl;
                Logger.d$default(Logger.INSTANCE, null, 1, null).with(this.this$0).addArg((Object)((Object)SocketClientImpl.access$getMStatus$p(this.this$0))).addArg(this.$socketData).print();
                if (SocketClientImpl.access$getMStatus$p(this.this$0) == Status.CONNECTED) {
                    boolean bl2;
                    try {
                        boolean bl3;
                        WebSocket webSocket = SocketClientImpl.access$getMWebSocket$p(this.this$0);
                        if (webSocket != null) {
                            byte[] byArray = this.$socketData.toByteArray();
                            bl3 = webSocket.send(ByteString.of((byte[])Arrays.copyOf(byArray, byArray.length)));
                        } else {
                            bl3 = false;
                        }
                        bl2 = bl3;
                    }
                    catch (Exception e) {
                        Logger.INSTANCE.e(e).with(this.this$0).print();
                        bl2 = false;
                    }
                    bl = bl2;
                } else {
                    bl = false;
                }
                return bl;
            }
            {
                this.this$0 = socketClientImpl;
                this.$socketData = socketData;
            }
        }).flatMap(new Function<T, SingleSource<? extends R>>(this){
            final /* synthetic */ SocketClientImpl this$0;

            @NotNull
            public final Single<Boolean> apply(@NotNull Boolean it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it != false ? Single.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).map((Function)new Function<T, R>(this){
                    final /* synthetic */ send.2 this$0;

                    public final boolean apply(@NotNull Long it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return SocketClientImpl.access$getMStatus$p(this.this$0.this$0) == Status.CONNECTED;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }) : Single.just((Object)false);
            }
            {
                this.this$0 = socketClientImpl;
            }
        }).doOnSuccess((Consumer)new Consumer<Boolean>(this){
            final /* synthetic */ SocketClientImpl this$0;

            public final void accept(Boolean it) {
                Logger.i$default(Logger.INSTANCE, null, 1, null).setResult(it).with(this.this$0).print();
            }
            {
                this.this$0 = socketClientImpl;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single\n        .fromCall\u2026ntImpl).print()\n        }");
        return single;
    }

    public synchronized void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
        block1: {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).print();
                this.mStatus = Status.CONNECTED;
                if (!this.mDisconnectAfterConnecting) break block0;
                this.mDisconnectAfterConnecting = false;
                this.disconnecting();
                break block1;
            }
            ObservableEmitter<SocketData> observableEmitter = this.mEmitter;
            if (observableEmitter == null) break block1;
            observableEmitter.onNext((Object)new SocketData(null, 0, SocketCommand.START, 0, 0, 0L, 0L, 0L, 251, null));
        }
    }

    public synchronized void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).addArg(code).addArg(reason).print();
    }

    public synchronized void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        block2: {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
                Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
                Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).addArg(code).addArg(reason).print();
                this.mStatus = Status.DISCONNECTED;
                this.mWebSocket = null;
                if (!this.mConnectAfterDisconnecting) break block1;
                this.mConnectAfterDisconnecting = false;
                this.connecting();
                break block2;
            }
            if (code == 1000) break block2;
            ObservableEmitter<SocketData> observableEmitter = this.mEmitter;
            if (observableEmitter != null) {
                observableEmitter.onError((Throwable)new GeoException.SocketClose(code, reason));
            }
        }
    }

    public synchronized void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
        block9: {
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
            Logger.INSTANCE.e(t).addArg((Object)this.mStatus).print();
            this.mStatus = Status.DISCONNECTED;
            this.mWebSocket = null;
            Object object = response;
            if (object != null && (object = object.body()) != null && (object = object.string()) != null) {
                JsonObject json;
                JsonObject jsonObject;
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                try {
                    jsonObject = (JsonObject)new Gson().fromJson((String)it, JsonObject.class);
                }
                catch (Exception e) {
                    jsonObject = null;
                }
                JsonObject jsonObject2 = json = jsonObject;
                if (jsonObject2 != null) {
                    jsonObject = jsonObject2;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    JsonObject it2 = jsonObject;
                    boolean bl6 = false;
                    if (json.has(ERROR_FIELD)) {
                        JsonElement jsonElement = json.get(ERROR_FIELD);
                        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"json.get(ERROR_FIELD)");
                        if (jsonElement.isJsonPrimitive()) {
                            JsonPrimitive jsonPrimitive;
                            JsonPrimitive jsonPrimitive2 = jsonPrimitive = json.getAsJsonPrimitive(ERROR_FIELD);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive2, (String)"jsonPrimitive");
                            if (jsonPrimitive2.isString() && Intrinsics.areEqual((Object)jsonPrimitive.getAsString(), (Object)"child_id is not equal to real id")) {
                                ObservableEmitter<SocketData> observableEmitter = this.mEmitter;
                                if (observableEmitter != null) {
                                    char[] cArray;
                                    JsonElement jsonElement2 = json.get("child_id");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"json.get(\"child_id\")");
                                    JsonPrimitive jsonPrimitive3 = jsonElement2.getAsJsonPrimitive();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonPrimitive3, (String)"json.get(\"child_id\").asJsonPrimitive");
                                    String string2 = jsonPrimitive3.getAsString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"json.get(\"child_id\").asJsonPrimitive.asString");
                                    String string3 = string2;
                                    ObservableEmitter<SocketData> observableEmitter2 = observableEmitter;
                                    boolean bl7 = false;
                                    String string4 = string3;
                                    if (string4 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    char[] cArray2 = string4.toCharArray();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
                                    char[] cArray3 = cArray = cArray2;
                                    observableEmitter2.onError((Throwable)new GeoException.SocketInvalidUserId(cArray3));
                                }
                                return;
                            }
                        }
                    }
                }
            }
            ObservableEmitter<SocketData> observableEmitter = this.mEmitter;
            if (observableEmitter == null) break block9;
            observableEmitter.onError((Throwable)new GeoException.Socket(t));
        }
    }

    public synchronized void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
        block3: {
            SocketData socketData;
            SocketData socketData2;
            Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
            Intrinsics.checkParameterIsNotNull((Object)bytes, (String)"bytes");
            Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).addArg(bytes).print();
            try {
                byte[] byArray = bytes.toByteArray();
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bytes.toByteArray()");
                socketData2 = SocketDataFactory.INSTANCE.createSocketData(byArray);
            }
            catch (Exception e) {
                Logger.INSTANCE.e(e).print();
                socketData2 = null;
            }
            SocketData socketData3 = socketData = socketData2;
            if (socketData3 == null) break block3;
            socketData2 = socketData3;
            boolean bl = false;
            boolean bl2 = false;
            SocketData it = socketData2;
            boolean bl3 = false;
            ObservableEmitter<SocketData> observableEmitter = this.mEmitter;
            if (observableEmitter != null) {
                observableEmitter.onNext((Object)it);
            }
        }
    }

    public synchronized void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)webSocket, (String)"webSocket");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).addArg(text).print();
        if (Intrinsics.areEqual((Object)text, (Object)STOP_WORD)) {
            this.disconnecting();
        }
    }

    private final void connecting() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).print();
        this.mStatus = Status.CONNECTING;
        Request.Builder builder = new Request.Builder();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.mLocalPreferences.getBaseUrl();
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        StringBuilder stringBuilder2 = stringBuilder.append(string2).append("?child_id=");
        char[] cArray = this.mLocalPreferences.getUserId();
        if (cArray == null) {
            Intrinsics.throwNpe();
        }
        char[] cArray2 = cArray;
        CharSequence charSequence = stringBuilder2;
        Request.Builder builder2 = builder;
        boolean bl = false;
        String string3 = new String(cArray2);
        Request.Builder builder3 = builder2.url(charSequence.append(string3).toString()).addHeader("Geo-Version", "1.20");
        StringBuilder stringBuilder3 = new StringBuilder().append("android/");
        String string4 = Build.MANUFACTURER;
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"Build.MANUFACTURER");
        Request.Builder builder4 = builder3.addHeader("Geo-Device", stringBuilder3.append(StringsKt.replace$default((String)string4, (String)" ", (String)"_", (boolean)false, (int)4, null)).append("/").append(Build.VERSION.SDK_INT).toString());
        char[] cArray3 = this.mLocalPreferences.getApiKey();
        if (cArray3 == null) {
            Intrinsics.throwNpe();
        }
        cArray2 = cArray3;
        charSequence = "Geo-AccessToken";
        builder2 = builder4;
        bl = false;
        string3 = new String(cArray2);
        Request.Builder builder5 = builder2.addHeader((String)charSequence, string3);
        char[] cArray4 = this.mLocalPreferences.getUserToken();
        if (cArray4 == null) {
            Intrinsics.throwNpe();
        }
        cArray2 = cArray4;
        charSequence = "Geo-UserToken";
        builder2 = builder5;
        bl = false;
        string3 = new String(cArray2);
        Request request2 = builder2.addHeader((String)charSequence, string3).addHeader("Geo-AppVersion", this.mAppVersion).addHeader("Geo-Session", "").build();
        this.mWebSocket = this.mOkHttpClient.newWebSocket(request2, (WebSocketListener)this);
    }

    private final void disconnecting() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).addArg((Object)this.mStatus).print();
        this.mStatus = Status.DISCONNECTING;
        WebSocket webSocket = this.mWebSocket;
        if (webSocket != null) {
            webSocket.close(1000, STOP_WORD);
        }
        this.mWebSocket = null;
    }

    private final void nothing() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
    }

    @Inject
    public SocketClientImpl(@NotNull LocalPreferences mLocalPreferences, @NotNull String mAppVersion) {
        Intrinsics.checkParameterIsNotNull((Object)mLocalPreferences, (String)"mLocalPreferences");
        Intrinsics.checkParameterIsNotNull((Object)mAppVersion, (String)"mAppVersion");
        this.mLocalPreferences = mLocalPreferences;
        this.mAppVersion = mAppVersion;
        this.mStatus = Status.DISCONNECTED;
        this.mOkHttpClient = new OkHttpClient();
    }

    public static final /* synthetic */ Status access$getMStatus$p(SocketClientImpl $this) {
        return $this.mStatus;
    }

    public static final /* synthetic */ void access$setMStatus$p(SocketClientImpl $this, Status status) {
        $this.mStatus = status;
    }

    public static final /* synthetic */ WebSocket access$getMWebSocket$p(SocketClientImpl $this) {
        return $this.mWebSocket;
    }

    public static final /* synthetic */ void access$setMWebSocket$p(SocketClientImpl $this, WebSocket webSocket) {
        $this.mWebSocket = webSocket;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/findmykids/geo/data/network/SocketClientImpl$Status;", "", "(Ljava/lang/String;I)V", "CONNECTED", "CONNECTING", "DISCONNECTING", "DISCONNECTED", "geo_release"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status CONNECTED;
        public static final /* enum */ Status CONNECTING;
        public static final /* enum */ Status DISCONNECTING;
        public static final /* enum */ Status DISCONNECTED;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[4];
            Status[] statusArray2 = statusArray;
            statusArray[0] = CONNECTED = new Status();
            statusArray[1] = CONNECTING = new Status();
            statusArray[2] = DISCONNECTING = new Status();
            statusArray[3] = DISCONNECTED = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string2) {
            return Enum.valueOf(Status.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/findmykids/geo/data/network/SocketClientImpl$Companion;", "", "()V", "ERROR_FIELD", "", "NORMAL_CLOSURE_STATUS", "", "STOP_WORD", "geo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

