/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.db.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.findmykids.geo.data.db.converter.ActivityTypesWithConfidencesMapConverter;
import org.findmykids.geo.data.db.converter.DateConverter;
import org.findmykids.geo.data.db.converter.ExtensionsConverter;
import org.findmykids.geo.data.db.converter.GpsInfoSatellitesInfosListConverter;
import org.findmykids.geo.data.db.converter.LocationSourceConverter;
import org.findmykids.geo.data.db.converter.SessionCommandsTypesListConverter;
import org.findmykids.geo.data.db.dao.SendGeoLocationsDao;
import org.findmykids.geo.data.db.model.SendGeoLocationEntity;
import org.findmykids.geo.data.model.ActivityType;
import org.findmykids.geo.data.model.CommandType;
import org.findmykids.geo.data.model.GpsInfo;
import org.findmykids.geo.data.model.LocationSource;

public final class SendGeoLocationsDao_Impl
implements SendGeoLocationsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<SendGeoLocationEntity> __insertionAdapterOfSendGeoLocationEntity;
    private final DateConverter __dateConverter = new DateConverter();
    private final SessionCommandsTypesListConverter __sessionCommandsTypesListConverter = new SessionCommandsTypesListConverter();
    private final LocationSourceConverter __locationSourceConverter = new LocationSourceConverter();
    private final GpsInfoSatellitesInfosListConverter __gpsInfoSatellitesInfosListConverter = new GpsInfoSatellitesInfosListConverter();
    private final ActivityTypesWithConfidencesMapConverter __activityTypesWithConfidencesMapConverter = new ActivityTypesWithConfidencesMapConverter();
    private final ExtensionsConverter __extensionsConverter = new ExtensionsConverter();
    private final EntityDeletionOrUpdateAdapter<SendGeoLocationEntity> __deletionAdapterOfSendGeoLocationEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public SendGeoLocationsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSendGeoLocationEntity = new EntityInsertionAdapter<SendGeoLocationEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `SendGeoLocationEntity` (`id`,`create`,`sessionIndex`,`sessionCreate`,`sessionIsRealtime`,`sessionCommandsTypes`,`locationLatitude`,`locationLongitude`,`locationProvider`,`locationTime`,`locationAltitude`,`locationAccuracy`,`locationBearing`,`locationElapsedRealtimeUncertaintyNanos`,`locationSpeed`,`locationSpeedAccuracyMetersPerSecond`,`locationVerticalAccuracyMeters`,`locationBearingAccuracyDegrees`,`locationElapsedRealtimeNanos`,`locationSource`,`locationDefineSessionIndex`,`locationDefineGlobalIndex`,`calculatedLocationExist`,`calculatedLocationLatitude`,`calculatedLocationLongitude`,`calculatedLocationAltitude`,`calculatedLocationSpeed`,`gpsInfoExist`,`gpsInfoTimeToFirstFix`,`gpsInfoMaxSatellites`,`gpsInfoSatellites`,`activityExist`,`activityElapsedRealtimeMillis`,`activityTime`,`activityActivitiesWithConfidences`,`batteryExist`,`batteryIsCharging`,`batteryLevel`,`wifiExist`,`wifiSsid`,`wifiMac`,`wifiLevel`,`sendReason`,`sendSessionIndex`,`sendGlobalIndex`,`extensions`) VALUES (nullif(?, 0),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SendGeoLocationEntity value) {
                Integer _tmp_11;
                stmt.bindLong(1, (long)value.getId());
                long _tmp = SendGeoLocationsDao_Impl.this.__dateConverter.from(value.getCreate());
                stmt.bindLong(2, _tmp);
                stmt.bindLong(3, value.getSessionIndex());
                long _tmp_1 = SendGeoLocationsDao_Impl.this.__dateConverter.from(value.getSessionCreate());
                stmt.bindLong(4, _tmp_1);
                int _tmp_2 = value.getSessionIsRealtime() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                String _tmp_3 = SendGeoLocationsDao_Impl.this.__sessionCommandsTypesListConverter.from(value.getSessionCommandsTypes());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_3);
                }
                stmt.bindDouble(7, value.getLocationLatitude());
                stmt.bindDouble(8, value.getLocationLongitude());
                if (value.getLocationProvider() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getLocationProvider());
                }
                stmt.bindLong(10, value.getLocationTime());
                if (value.getLocationAltitude() == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindDouble(11, value.getLocationAltitude().doubleValue());
                }
                if (value.getLocationAccuracy() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindDouble(12, (double)value.getLocationAccuracy().floatValue());
                }
                if (value.getLocationBearing() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindDouble(13, (double)value.getLocationBearing().floatValue());
                }
                if (value.getLocationElapsedRealtimeUncertaintyNanos() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindDouble(14, value.getLocationElapsedRealtimeUncertaintyNanos().doubleValue());
                }
                if (value.getLocationSpeed() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindDouble(15, (double)value.getLocationSpeed().floatValue());
                }
                if (value.getLocationSpeedAccuracyMetersPerSecond() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindDouble(16, (double)value.getLocationSpeedAccuracyMetersPerSecond().floatValue());
                }
                if (value.getLocationVerticalAccuracyMeters() == null) {
                    stmt.bindNull(17);
                } else {
                    stmt.bindDouble(17, (double)value.getLocationVerticalAccuracyMeters().floatValue());
                }
                if (value.getLocationBearingAccuracyDegrees() == null) {
                    stmt.bindNull(18);
                } else {
                    stmt.bindDouble(18, (double)value.getLocationBearingAccuracyDegrees().floatValue());
                }
                if (value.getLocationElapsedRealtimeNanos() == null) {
                    stmt.bindNull(19);
                } else {
                    stmt.bindLong(19, value.getLocationElapsedRealtimeNanos().longValue());
                }
                String _tmp_4 = SendGeoLocationsDao_Impl.this.__locationSourceConverter.from(value.getLocationSource());
                if (_tmp_4 == null) {
                    stmt.bindNull(20);
                } else {
                    stmt.bindString(20, _tmp_4);
                }
                stmt.bindLong(21, value.getLocationDefineSessionIndex());
                stmt.bindLong(22, value.getLocationDefineGlobalIndex());
                int _tmp_5 = value.getCalculatedLocationExist() ? 1 : 0;
                stmt.bindLong(23, (long)_tmp_5);
                if (value.getCalculatedLocationLatitude() == null) {
                    stmt.bindNull(24);
                } else {
                    stmt.bindDouble(24, value.getCalculatedLocationLatitude().doubleValue());
                }
                if (value.getCalculatedLocationLongitude() == null) {
                    stmt.bindNull(25);
                } else {
                    stmt.bindDouble(25, value.getCalculatedLocationLongitude().doubleValue());
                }
                if (value.getCalculatedLocationAltitude() == null) {
                    stmt.bindNull(26);
                } else {
                    stmt.bindDouble(26, value.getCalculatedLocationAltitude().doubleValue());
                }
                if (value.getCalculatedLocationSpeed() == null) {
                    stmt.bindNull(27);
                } else {
                    stmt.bindDouble(27, value.getCalculatedLocationSpeed().doubleValue());
                }
                int _tmp_6 = value.getGpsInfoExist() ? 1 : 0;
                stmt.bindLong(28, (long)_tmp_6);
                if (value.getGpsInfoTimeToFirstFix() == null) {
                    stmt.bindNull(29);
                } else {
                    stmt.bindLong(29, (long)value.getGpsInfoTimeToFirstFix().intValue());
                }
                if (value.getGpsInfoMaxSatellites() == null) {
                    stmt.bindNull(30);
                } else {
                    stmt.bindLong(30, (long)value.getGpsInfoMaxSatellites().intValue());
                }
                String _tmp_7 = SendGeoLocationsDao_Impl.this.__gpsInfoSatellitesInfosListConverter.from(value.getGpsInfoSatellites());
                if (_tmp_7 == null) {
                    stmt.bindNull(31);
                } else {
                    stmt.bindString(31, _tmp_7);
                }
                int _tmp_8 = value.getActivityExist() ? 1 : 0;
                stmt.bindLong(32, (long)_tmp_8);
                if (value.getActivityElapsedRealtimeMillis() == null) {
                    stmt.bindNull(33);
                } else {
                    stmt.bindLong(33, value.getActivityElapsedRealtimeMillis().longValue());
                }
                if (value.getActivityTime() == null) {
                    stmt.bindNull(34);
                } else {
                    stmt.bindLong(34, value.getActivityTime().longValue());
                }
                String _tmp_9 = SendGeoLocationsDao_Impl.this.__activityTypesWithConfidencesMapConverter.from(value.getActivityActivitiesWithConfidences());
                if (_tmp_9 == null) {
                    stmt.bindNull(35);
                } else {
                    stmt.bindString(35, _tmp_9);
                }
                int _tmp_10 = value.getBatteryExist() ? 1 : 0;
                stmt.bindLong(36, (long)_tmp_10);
                Integer n = value.getBatteryIsCharging() == null ? null : (_tmp_11 = Integer.valueOf(value.getBatteryIsCharging() != false ? 1 : 0));
                if (_tmp_11 == null) {
                    stmt.bindNull(37);
                } else {
                    stmt.bindLong(37, (long)_tmp_11.intValue());
                }
                if (value.getBatteryLevel() == null) {
                    stmt.bindNull(38);
                } else {
                    stmt.bindLong(38, (long)value.getBatteryLevel().intValue());
                }
                int _tmp_12 = value.getWifiExist() ? 1 : 0;
                stmt.bindLong(39, (long)_tmp_12);
                if (value.getWifiSsid() == null) {
                    stmt.bindNull(40);
                } else {
                    stmt.bindString(40, value.getWifiSsid());
                }
                if (value.getWifiMac() == null) {
                    stmt.bindNull(41);
                } else {
                    stmt.bindString(41, value.getWifiMac());
                }
                if (value.getWifiLevel() == null) {
                    stmt.bindNull(42);
                } else {
                    stmt.bindLong(42, (long)value.getWifiLevel().intValue());
                }
                if (value.getSendReason() == null) {
                    stmt.bindNull(43);
                } else {
                    stmt.bindString(43, value.getSendReason());
                }
                stmt.bindLong(44, value.getSendSessionIndex());
                stmt.bindLong(45, value.getSendGlobalIndex());
                String _tmp_13 = SendGeoLocationsDao_Impl.this.__extensionsConverter.from(value.getExtensions());
                if (_tmp_13 == null) {
                    stmt.bindNull(46);
                } else {
                    stmt.bindString(46, _tmp_13);
                }
            }
        };
        this.__deletionAdapterOfSendGeoLocationEntity = new EntityDeletionOrUpdateAdapter<SendGeoLocationEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `SendGeoLocationEntity` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, SendGeoLocationEntity value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM SendGeoLocationEntity";
                return "DELETE FROM SendGeoLocationEntity";
            }
        };
    }

    @Override
    public void insert(SendGeoLocationEntity sendGeoLocationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSendGeoLocationEntity.insert((Object)sendGeoLocationEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(SendGeoLocationEntity sendGeoLocationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfSendGeoLocationEntity.handle((Object)sendGeoLocationEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        String _sql = "SELECT COUNT(id) FROM SendGeoLocationEntity";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(id) FROM SendGeoLocationEntity", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendGeoLocationEntity> selectOnline(long sessionIndex, long nowTime) {
        String _sql = "SELECT * FROM SendGeoLocationEntity WHERE sessionIndex = ? AND ? - sessionCreate < 60000";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SendGeoLocationEntity WHERE sessionIndex = ? AND ? - sessionCreate < 60000", (int)2);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, sessionIndex);
        _argIndex = 2;
        _statement.bindLong(_argIndex, nowTime);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"create");
            int _cursorIndexOfSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIndex");
            int _cursorIndexOfSessionCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCreate");
            int _cursorIndexOfSessionIsRealtime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIsRealtime");
            int _cursorIndexOfSessionCommandsTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCommandsTypes");
            int _cursorIndexOfLocationLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationLatitude");
            int _cursorIndexOfLocationLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationLongitude");
            int _cursorIndexOfLocationProvider = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationProvider");
            int _cursorIndexOfLocationTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationTime");
            int _cursorIndexOfLocationAltitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationAltitude");
            int _cursorIndexOfLocationAccuracy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationAccuracy");
            int _cursorIndexOfLocationBearing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationBearing");
            int _cursorIndexOfLocationElapsedRealtimeUncertaintyNanos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationElapsedRealtimeUncertaintyNanos");
            int _cursorIndexOfLocationSpeed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSpeed");
            int _cursorIndexOfLocationSpeedAccuracyMetersPerSecond = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSpeedAccuracyMetersPerSecond");
            int _cursorIndexOfLocationVerticalAccuracyMeters = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationVerticalAccuracyMeters");
            int _cursorIndexOfLocationBearingAccuracyDegrees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationBearingAccuracyDegrees");
            int _cursorIndexOfLocationElapsedRealtimeNanos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationElapsedRealtimeNanos");
            int _cursorIndexOfLocationSource = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSource");
            int _cursorIndexOfLocationDefineSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationDefineSessionIndex");
            int _cursorIndexOfLocationDefineGlobalIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationDefineGlobalIndex");
            int _cursorIndexOfCalculatedLocationExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationExist");
            int _cursorIndexOfCalculatedLocationLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationLatitude");
            int _cursorIndexOfCalculatedLocationLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationLongitude");
            int _cursorIndexOfCalculatedLocationAltitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationAltitude");
            int _cursorIndexOfCalculatedLocationSpeed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationSpeed");
            int _cursorIndexOfGpsInfoExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoExist");
            int _cursorIndexOfGpsInfoTimeToFirstFix = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoTimeToFirstFix");
            int _cursorIndexOfGpsInfoMaxSatellites = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoMaxSatellites");
            int _cursorIndexOfGpsInfoSatellites = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoSatellites");
            int _cursorIndexOfActivityExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityExist");
            int _cursorIndexOfActivityElapsedRealtimeMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityElapsedRealtimeMillis");
            int _cursorIndexOfActivityTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityTime");
            int _cursorIndexOfActivityActivitiesWithConfidences = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityActivitiesWithConfidences");
            int _cursorIndexOfBatteryExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryExist");
            int _cursorIndexOfBatteryIsCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryIsCharging");
            int _cursorIndexOfBatteryLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryLevel");
            int _cursorIndexOfWifiExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiExist");
            int _cursorIndexOfWifiSsid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiSsid");
            int _cursorIndexOfWifiMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiMac");
            int _cursorIndexOfWifiLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiLevel");
            int _cursorIndexOfSendReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendReason");
            int _cursorIndexOfSendSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendSessionIndex");
            int _cursorIndexOfSendGlobalIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendGlobalIndex");
            int _cursorIndexOfExtensions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensions");
            ArrayList<SendGeoLocationEntity> _result = new ArrayList<SendGeoLocationEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                long _tmp = _cursor.getLong(_cursorIndexOfCreate);
                Date _tmpCreate = this.__dateConverter.to(_tmp);
                long _tmpSessionIndex = _cursor.getLong(_cursorIndexOfSessionIndex);
                long _tmp_1 = _cursor.getLong(_cursorIndexOfSessionCreate);
                Date _tmpSessionCreate = this.__dateConverter.to(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfSessionIsRealtime);
                boolean _tmpSessionIsRealtime = _tmp_2 != 0;
                String _tmp_3 = _cursor.getString(_cursorIndexOfSessionCommandsTypes);
                List<CommandType> _tmpSessionCommandsTypes = this.__sessionCommandsTypesListConverter.to(_tmp_3);
                double _tmpLocationLatitude = _cursor.getDouble(_cursorIndexOfLocationLatitude);
                double _tmpLocationLongitude = _cursor.getDouble(_cursorIndexOfLocationLongitude);
                String _tmpLocationProvider = _cursor.getString(_cursorIndexOfLocationProvider);
                long _tmpLocationTime = _cursor.getLong(_cursorIndexOfLocationTime);
                Double _tmpLocationAltitude = _cursor.isNull(_cursorIndexOfLocationAltitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLocationAltitude));
                Float _tmpLocationAccuracy = _cursor.isNull(_cursorIndexOfLocationAccuracy) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationAccuracy));
                Float _tmpLocationBearing = _cursor.isNull(_cursorIndexOfLocationBearing) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationBearing));
                Double _tmpLocationElapsedRealtimeUncertaintyNanos = _cursor.isNull(_cursorIndexOfLocationElapsedRealtimeUncertaintyNanos) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLocationElapsedRealtimeUncertaintyNanos));
                Float _tmpLocationSpeed = _cursor.isNull(_cursorIndexOfLocationSpeed) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationSpeed));
                Float _tmpLocationSpeedAccuracyMetersPerSecond = _cursor.isNull(_cursorIndexOfLocationSpeedAccuracyMetersPerSecond) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationSpeedAccuracyMetersPerSecond));
                Float _tmpLocationVerticalAccuracyMeters = _cursor.isNull(_cursorIndexOfLocationVerticalAccuracyMeters) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationVerticalAccuracyMeters));
                Float _tmpLocationBearingAccuracyDegrees = _cursor.isNull(_cursorIndexOfLocationBearingAccuracyDegrees) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationBearingAccuracyDegrees));
                Long _tmpLocationElapsedRealtimeNanos = _cursor.isNull(_cursorIndexOfLocationElapsedRealtimeNanos) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLocationElapsedRealtimeNanos));
                String _tmp_4 = _cursor.getString(_cursorIndexOfLocationSource);
                LocationSource _tmpLocationSource = this.__locationSourceConverter.to(_tmp_4);
                long _tmpLocationDefineSessionIndex = _cursor.getLong(_cursorIndexOfLocationDefineSessionIndex);
                long _tmpLocationDefineGlobalIndex = _cursor.getLong(_cursorIndexOfLocationDefineGlobalIndex);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfCalculatedLocationExist);
                boolean _tmpCalculatedLocationExist = _tmp_5 != 0;
                Double _tmpCalculatedLocationLatitude = _cursor.isNull(_cursorIndexOfCalculatedLocationLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationLatitude));
                Double _tmpCalculatedLocationLongitude = _cursor.isNull(_cursorIndexOfCalculatedLocationLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationLongitude));
                Double _tmpCalculatedLocationAltitude = _cursor.isNull(_cursorIndexOfCalculatedLocationAltitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationAltitude));
                Double _tmpCalculatedLocationSpeed = _cursor.isNull(_cursorIndexOfCalculatedLocationSpeed) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationSpeed));
                int _tmp_6 = _cursor.getInt(_cursorIndexOfGpsInfoExist);
                boolean _tmpGpsInfoExist = _tmp_6 != 0;
                Integer _tmpGpsInfoTimeToFirstFix = _cursor.isNull(_cursorIndexOfGpsInfoTimeToFirstFix) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfGpsInfoTimeToFirstFix));
                Integer _tmpGpsInfoMaxSatellites = _cursor.isNull(_cursorIndexOfGpsInfoMaxSatellites) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfGpsInfoMaxSatellites));
                String _tmp_7 = _cursor.getString(_cursorIndexOfGpsInfoSatellites);
                List<GpsInfo.SatelliteInfo> _tmpGpsInfoSatellites = this.__gpsInfoSatellitesInfosListConverter.to(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfActivityExist);
                boolean _tmpActivityExist = _tmp_8 != 0;
                Long _tmpActivityElapsedRealtimeMillis = _cursor.isNull(_cursorIndexOfActivityElapsedRealtimeMillis) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityElapsedRealtimeMillis));
                Long _tmpActivityTime = _cursor.isNull(_cursorIndexOfActivityTime) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityTime));
                String _tmp_9 = _cursor.getString(_cursorIndexOfActivityActivitiesWithConfidences);
                Map<ActivityType, Integer> _tmpActivityActivitiesWithConfidences = this.__activityTypesWithConfidencesMapConverter.to(_tmp_9);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfBatteryExist);
                boolean _tmpBatteryExist = _tmp_10 != 0;
                Integer _tmp_11 = _cursor.isNull(_cursorIndexOfBatteryIsCharging) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryIsCharging));
                Boolean _tmpBatteryIsCharging = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                Integer _tmpBatteryLevel = _cursor.isNull(_cursorIndexOfBatteryLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryLevel));
                int _tmp_12 = _cursor.getInt(_cursorIndexOfWifiExist);
                boolean _tmpWifiExist = _tmp_12 != 0;
                String _tmpWifiSsid = _cursor.getString(_cursorIndexOfWifiSsid);
                String _tmpWifiMac = _cursor.getString(_cursorIndexOfWifiMac);
                Integer _tmpWifiLevel = _cursor.isNull(_cursorIndexOfWifiLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWifiLevel));
                String _tmpSendReason = _cursor.getString(_cursorIndexOfSendReason);
                long _tmpSendSessionIndex = _cursor.getLong(_cursorIndexOfSendSessionIndex);
                long _tmpSendGlobalIndex = _cursor.getLong(_cursorIndexOfSendGlobalIndex);
                String _tmp_13 = _cursor.getString(_cursorIndexOfExtensions);
                Map<String, String> _tmpExtensions = this.__extensionsConverter.to(_tmp_13);
                SendGeoLocationEntity _item = new SendGeoLocationEntity(_tmpId, _tmpCreate, _tmpSessionIndex, _tmpSessionCreate, _tmpSessionIsRealtime, _tmpSessionCommandsTypes, _tmpLocationLatitude, _tmpLocationLongitude, _tmpLocationProvider, _tmpLocationTime, _tmpLocationAltitude, _tmpLocationAccuracy, _tmpLocationBearing, _tmpLocationElapsedRealtimeUncertaintyNanos, _tmpLocationSpeed, _tmpLocationSpeedAccuracyMetersPerSecond, _tmpLocationVerticalAccuracyMeters, _tmpLocationBearingAccuracyDegrees, _tmpLocationElapsedRealtimeNanos, _tmpLocationSource, _tmpLocationDefineSessionIndex, _tmpLocationDefineGlobalIndex, _tmpCalculatedLocationExist, _tmpCalculatedLocationLatitude, _tmpCalculatedLocationLongitude, _tmpCalculatedLocationAltitude, _tmpCalculatedLocationSpeed, _tmpGpsInfoExist, _tmpGpsInfoTimeToFirstFix, _tmpGpsInfoMaxSatellites, _tmpGpsInfoSatellites, _tmpActivityExist, _tmpActivityElapsedRealtimeMillis, _tmpActivityTime, _tmpActivityActivitiesWithConfidences, _tmpBatteryExist, _tmpBatteryIsCharging, _tmpBatteryLevel, _tmpWifiExist, _tmpWifiSsid, _tmpWifiMac, _tmpWifiLevel, _tmpSendReason, _tmpSendSessionIndex, _tmpSendGlobalIndex, _tmpExtensions);
                _result.add(_item);
            }
            ArrayList<SendGeoLocationEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SendGeoLocationEntity> select(int limit) {
        String _sql = "SELECT * FROM SendGeoLocationEntity LIMIT ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SendGeoLocationEntity LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"create");
            int _cursorIndexOfSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIndex");
            int _cursorIndexOfSessionCreate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCreate");
            int _cursorIndexOfSessionIsRealtime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionIsRealtime");
            int _cursorIndexOfSessionCommandsTypes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionCommandsTypes");
            int _cursorIndexOfLocationLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationLatitude");
            int _cursorIndexOfLocationLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationLongitude");
            int _cursorIndexOfLocationProvider = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationProvider");
            int _cursorIndexOfLocationTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationTime");
            int _cursorIndexOfLocationAltitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationAltitude");
            int _cursorIndexOfLocationAccuracy = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationAccuracy");
            int _cursorIndexOfLocationBearing = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationBearing");
            int _cursorIndexOfLocationElapsedRealtimeUncertaintyNanos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationElapsedRealtimeUncertaintyNanos");
            int _cursorIndexOfLocationSpeed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSpeed");
            int _cursorIndexOfLocationSpeedAccuracyMetersPerSecond = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSpeedAccuracyMetersPerSecond");
            int _cursorIndexOfLocationVerticalAccuracyMeters = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationVerticalAccuracyMeters");
            int _cursorIndexOfLocationBearingAccuracyDegrees = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationBearingAccuracyDegrees");
            int _cursorIndexOfLocationElapsedRealtimeNanos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationElapsedRealtimeNanos");
            int _cursorIndexOfLocationSource = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationSource");
            int _cursorIndexOfLocationDefineSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationDefineSessionIndex");
            int _cursorIndexOfLocationDefineGlobalIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"locationDefineGlobalIndex");
            int _cursorIndexOfCalculatedLocationExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationExist");
            int _cursorIndexOfCalculatedLocationLatitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationLatitude");
            int _cursorIndexOfCalculatedLocationLongitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationLongitude");
            int _cursorIndexOfCalculatedLocationAltitude = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationAltitude");
            int _cursorIndexOfCalculatedLocationSpeed = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"calculatedLocationSpeed");
            int _cursorIndexOfGpsInfoExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoExist");
            int _cursorIndexOfGpsInfoTimeToFirstFix = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoTimeToFirstFix");
            int _cursorIndexOfGpsInfoMaxSatellites = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoMaxSatellites");
            int _cursorIndexOfGpsInfoSatellites = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"gpsInfoSatellites");
            int _cursorIndexOfActivityExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityExist");
            int _cursorIndexOfActivityElapsedRealtimeMillis = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityElapsedRealtimeMillis");
            int _cursorIndexOfActivityTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityTime");
            int _cursorIndexOfActivityActivitiesWithConfidences = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"activityActivitiesWithConfidences");
            int _cursorIndexOfBatteryExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryExist");
            int _cursorIndexOfBatteryIsCharging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryIsCharging");
            int _cursorIndexOfBatteryLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"batteryLevel");
            int _cursorIndexOfWifiExist = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiExist");
            int _cursorIndexOfWifiSsid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiSsid");
            int _cursorIndexOfWifiMac = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiMac");
            int _cursorIndexOfWifiLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"wifiLevel");
            int _cursorIndexOfSendReason = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendReason");
            int _cursorIndexOfSendSessionIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendSessionIndex");
            int _cursorIndexOfSendGlobalIndex = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sendGlobalIndex");
            int _cursorIndexOfExtensions = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"extensions");
            ArrayList<SendGeoLocationEntity> _result = new ArrayList<SendGeoLocationEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                long _tmp = _cursor.getLong(_cursorIndexOfCreate);
                Date _tmpCreate = this.__dateConverter.to(_tmp);
                long _tmpSessionIndex = _cursor.getLong(_cursorIndexOfSessionIndex);
                long _tmp_1 = _cursor.getLong(_cursorIndexOfSessionCreate);
                Date _tmpSessionCreate = this.__dateConverter.to(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfSessionIsRealtime);
                boolean _tmpSessionIsRealtime = _tmp_2 != 0;
                String _tmp_3 = _cursor.getString(_cursorIndexOfSessionCommandsTypes);
                List<CommandType> _tmpSessionCommandsTypes = this.__sessionCommandsTypesListConverter.to(_tmp_3);
                double _tmpLocationLatitude = _cursor.getDouble(_cursorIndexOfLocationLatitude);
                double _tmpLocationLongitude = _cursor.getDouble(_cursorIndexOfLocationLongitude);
                String _tmpLocationProvider = _cursor.getString(_cursorIndexOfLocationProvider);
                long _tmpLocationTime = _cursor.getLong(_cursorIndexOfLocationTime);
                Double _tmpLocationAltitude = _cursor.isNull(_cursorIndexOfLocationAltitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLocationAltitude));
                Float _tmpLocationAccuracy = _cursor.isNull(_cursorIndexOfLocationAccuracy) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationAccuracy));
                Float _tmpLocationBearing = _cursor.isNull(_cursorIndexOfLocationBearing) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationBearing));
                Double _tmpLocationElapsedRealtimeUncertaintyNanos = _cursor.isNull(_cursorIndexOfLocationElapsedRealtimeUncertaintyNanos) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfLocationElapsedRealtimeUncertaintyNanos));
                Float _tmpLocationSpeed = _cursor.isNull(_cursorIndexOfLocationSpeed) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationSpeed));
                Float _tmpLocationSpeedAccuracyMetersPerSecond = _cursor.isNull(_cursorIndexOfLocationSpeedAccuracyMetersPerSecond) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationSpeedAccuracyMetersPerSecond));
                Float _tmpLocationVerticalAccuracyMeters = _cursor.isNull(_cursorIndexOfLocationVerticalAccuracyMeters) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationVerticalAccuracyMeters));
                Float _tmpLocationBearingAccuracyDegrees = _cursor.isNull(_cursorIndexOfLocationBearingAccuracyDegrees) ? null : Float.valueOf(_cursor.getFloat(_cursorIndexOfLocationBearingAccuracyDegrees));
                Long _tmpLocationElapsedRealtimeNanos = _cursor.isNull(_cursorIndexOfLocationElapsedRealtimeNanos) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfLocationElapsedRealtimeNanos));
                String _tmp_4 = _cursor.getString(_cursorIndexOfLocationSource);
                LocationSource _tmpLocationSource = this.__locationSourceConverter.to(_tmp_4);
                long _tmpLocationDefineSessionIndex = _cursor.getLong(_cursorIndexOfLocationDefineSessionIndex);
                long _tmpLocationDefineGlobalIndex = _cursor.getLong(_cursorIndexOfLocationDefineGlobalIndex);
                int _tmp_5 = _cursor.getInt(_cursorIndexOfCalculatedLocationExist);
                boolean _tmpCalculatedLocationExist = _tmp_5 != 0;
                Double _tmpCalculatedLocationLatitude = _cursor.isNull(_cursorIndexOfCalculatedLocationLatitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationLatitude));
                Double _tmpCalculatedLocationLongitude = _cursor.isNull(_cursorIndexOfCalculatedLocationLongitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationLongitude));
                Double _tmpCalculatedLocationAltitude = _cursor.isNull(_cursorIndexOfCalculatedLocationAltitude) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationAltitude));
                Double _tmpCalculatedLocationSpeed = _cursor.isNull(_cursorIndexOfCalculatedLocationSpeed) ? null : Double.valueOf(_cursor.getDouble(_cursorIndexOfCalculatedLocationSpeed));
                int _tmp_6 = _cursor.getInt(_cursorIndexOfGpsInfoExist);
                boolean _tmpGpsInfoExist = _tmp_6 != 0;
                Integer _tmpGpsInfoTimeToFirstFix = _cursor.isNull(_cursorIndexOfGpsInfoTimeToFirstFix) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfGpsInfoTimeToFirstFix));
                Integer _tmpGpsInfoMaxSatellites = _cursor.isNull(_cursorIndexOfGpsInfoMaxSatellites) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfGpsInfoMaxSatellites));
                String _tmp_7 = _cursor.getString(_cursorIndexOfGpsInfoSatellites);
                List<GpsInfo.SatelliteInfo> _tmpGpsInfoSatellites = this.__gpsInfoSatellitesInfosListConverter.to(_tmp_7);
                int _tmp_8 = _cursor.getInt(_cursorIndexOfActivityExist);
                boolean _tmpActivityExist = _tmp_8 != 0;
                Long _tmpActivityElapsedRealtimeMillis = _cursor.isNull(_cursorIndexOfActivityElapsedRealtimeMillis) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityElapsedRealtimeMillis));
                Long _tmpActivityTime = _cursor.isNull(_cursorIndexOfActivityTime) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfActivityTime));
                String _tmp_9 = _cursor.getString(_cursorIndexOfActivityActivitiesWithConfidences);
                Map<ActivityType, Integer> _tmpActivityActivitiesWithConfidences = this.__activityTypesWithConfidencesMapConverter.to(_tmp_9);
                int _tmp_10 = _cursor.getInt(_cursorIndexOfBatteryExist);
                boolean _tmpBatteryExist = _tmp_10 != 0;
                Integer _tmp_11 = _cursor.isNull(_cursorIndexOfBatteryIsCharging) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryIsCharging));
                Boolean _tmpBatteryIsCharging = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                Integer _tmpBatteryLevel = _cursor.isNull(_cursorIndexOfBatteryLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBatteryLevel));
                int _tmp_12 = _cursor.getInt(_cursorIndexOfWifiExist);
                boolean _tmpWifiExist = _tmp_12 != 0;
                String _tmpWifiSsid = _cursor.getString(_cursorIndexOfWifiSsid);
                String _tmpWifiMac = _cursor.getString(_cursorIndexOfWifiMac);
                Integer _tmpWifiLevel = _cursor.isNull(_cursorIndexOfWifiLevel) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfWifiLevel));
                String _tmpSendReason = _cursor.getString(_cursorIndexOfSendReason);
                long _tmpSendSessionIndex = _cursor.getLong(_cursorIndexOfSendSessionIndex);
                long _tmpSendGlobalIndex = _cursor.getLong(_cursorIndexOfSendGlobalIndex);
                String _tmp_13 = _cursor.getString(_cursorIndexOfExtensions);
                Map<String, String> _tmpExtensions = this.__extensionsConverter.to(_tmp_13);
                SendGeoLocationEntity _item = new SendGeoLocationEntity(_tmpId, _tmpCreate, _tmpSessionIndex, _tmpSessionCreate, _tmpSessionIsRealtime, _tmpSessionCommandsTypes, _tmpLocationLatitude, _tmpLocationLongitude, _tmpLocationProvider, _tmpLocationTime, _tmpLocationAltitude, _tmpLocationAccuracy, _tmpLocationBearing, _tmpLocationElapsedRealtimeUncertaintyNanos, _tmpLocationSpeed, _tmpLocationSpeedAccuracyMetersPerSecond, _tmpLocationVerticalAccuracyMeters, _tmpLocationBearingAccuracyDegrees, _tmpLocationElapsedRealtimeNanos, _tmpLocationSource, _tmpLocationDefineSessionIndex, _tmpLocationDefineGlobalIndex, _tmpCalculatedLocationExist, _tmpCalculatedLocationLatitude, _tmpCalculatedLocationLongitude, _tmpCalculatedLocationAltitude, _tmpCalculatedLocationSpeed, _tmpGpsInfoExist, _tmpGpsInfoTimeToFirstFix, _tmpGpsInfoMaxSatellites, _tmpGpsInfoSatellites, _tmpActivityExist, _tmpActivityElapsedRealtimeMillis, _tmpActivityTime, _tmpActivityActivitiesWithConfidences, _tmpBatteryExist, _tmpBatteryIsCharging, _tmpBatteryLevel, _tmpWifiExist, _tmpWifiSsid, _tmpWifiMac, _tmpWifiLevel, _tmpSendReason, _tmpSendSessionIndex, _tmpSendGlobalIndex, _tmpExtensions);
                _result.add(_item);
            }
            ArrayList<SendGeoLocationEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

