/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.data.db.dao;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import org.findmykids.geo.data.db.converter.ConfigurationConverter;
import org.findmykids.geo.data.db.dao.ConfigurationsDao;
import org.findmykids.geo.data.db.model.ConfigurationEntity;
import org.findmykids.geo.data.model.Configuration;

public final class ConfigurationsDao_Impl
implements ConfigurationsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<ConfigurationEntity> __insertionAdapterOfConfigurationEntity;
    private final ConfigurationConverter __configurationConverter = new ConfigurationConverter();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public ConfigurationsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfConfigurationEntity = new EntityInsertionAdapter<ConfigurationEntity>(__db){

            public String createQuery() {
                return "INSERT OR ABORT INTO `ConfigurationEntity` (`id`,`configuration`) VALUES (nullif(?, 0),?)";
            }

            public void bind(SupportSQLiteStatement stmt, ConfigurationEntity value) {
                stmt.bindLong(1, (long)value.getId());
                String _tmp = ConfigurationsDao_Impl.this.__configurationConverter.fromConfiguration(value.getConfiguration());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM ConfigurationEntity";
                return "DELETE FROM ConfigurationEntity";
            }
        };
    }

    @Override
    public void insert(ConfigurationEntity configurationEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfConfigurationEntity.insert((Object)configurationEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigurationEntity> selectAll() {
        String _sql = "SELECT * FROM ConfigurationEntity";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM ConfigurationEntity", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfConfiguration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"configuration");
            ArrayList<ConfigurationEntity> _result = new ArrayList<ConfigurationEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                String _tmp = _cursor.getString(_cursorIndexOfConfiguration);
                Configuration _tmpConfiguration = this.__configurationConverter.toConfiguration(_tmp);
                ConfigurationEntity _item = new ConfigurationEntity(_tmpId, _tmpConfiguration);
                _result.add(_item);
            }
            ArrayList<ConfigurationEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

