/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.utils;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/findmykids/geo/common/utils/NotificationUtil;", "", "()V", "CHANNEL_ID", "", "CHANNEL_NAME", "create", "Landroid/app/Notification;", "context", "Landroid/content/Context;", "title", "description", "iconResourceId", "", "createNotificationChannel", "geo_release"})
public final class NotificationUtil {
    private static final String CHANNEL_ID = "Geo";
    private static final String CHANNEL_NAME = "Geo Background Service";
    public static final NotificationUtil INSTANCE;

    @NotNull
    public final Notification create(@NotNull Context context, @NotNull String title, @NotNull String description, int iconResourceId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        String channelId = Build.VERSION.SDK_INT >= 26 ? this.createNotificationChannel(context) : "";
        Notification notification = new NotificationCompat.Builder(context, channelId).setOngoing(true).setContentTitle((CharSequence)title).setContentText((CharSequence)description).setSmallIcon(iconResourceId).setTicker((CharSequence)"Ticker").build();
        Intrinsics.checkExpressionValueIsNotNull((Object)notification, (String)"NotificationCompat\n     \u2026er\")\n            .build()");
        return notification;
    }

    @RequiresApi(value=26)
    private final String createNotificationChannel(Context context) {
        block0: {
            NotificationManager service;
            NotificationChannel chan = new NotificationChannel(CHANNEL_ID, (CharSequence)CHANNEL_NAME, 0);
            chan.setLightColor(-16776961);
            chan.setLockscreenVisibility(0);
            NotificationManager notificationManager = service = (NotificationManager)ContextCompat.getSystemService((Context)context, NotificationManager.class);
            if (notificationManager == null) break block0;
            notificationManager.createNotificationChannel(chan);
        }
        return CHANNEL_ID;
    }

    private NotificationUtil() {
    }

    static {
        NotificationUtil notificationUtil;
        INSTANCE = notificationUtil = new NotificationUtil();
    }
}

