/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.di.session.module;

import android.content.Context;
import com.huawei.hms.location.ActivityIdentification;
import com.huawei.hms.location.LocationServices;
import dagger.Module;
import dagger.Provides;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.common.di.session.SessionScope;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.common.utils.ManufactureUtil;
import org.findmykids.geo.data.repository.trigger.activity.ActivityManager;
import org.findmykids.geo.data.repository.trigger.activity.google.ActivityGoogleManagerImpl;
import org.findmykids.geo.data.repository.trigger.activity.huawei.ActivityHuaweiManagerImpl;
import org.findmykids.geo.data.repository.trigger.passive.PassiveManager;
import org.findmykids.geo.data.repository.trigger.passive.googlefused.PassiveGoogleFusedManagerImpl;
import org.findmykids.geo.data.repository.trigger.passive.huaweifused.PassiveHuaweiFusedManagerImpl;
import org.findmykids.geo.data.repository.trigger.passive.locationmanager.PassiveLocationManagerManagerImpl;
import org.findmykids.geo.data.repository.trigger.station.StationManager;
import org.findmykids.geo.data.repository.trigger.station.google.StationGoogleManagerImpl;
import org.findmykids.geo.data.repository.trigger.station.huawei.StationHuaweiManagerImpl;
import org.findmykids.geo.data.repository.trigger.timer.TimerManager;
import org.findmykids.geo.data.repository.trigger.timer.alarm.TimerAlarmManagerImpl;
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager;
import org.findmykids.geo.data.repository.trigger.zones.google.ZonesGoogleManagerImpl;
import org.findmykids.geo.data.repository.trigger.zones.huawei.ZonesHuaweiManagerImpl;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/findmykids/geo/common/di/session/module/DataTriggerModule;", "", "()V", "provideActivityManager", "Lorg/findmykids/geo/data/repository/trigger/activity/ActivityManager;", "context", "Landroid/content/Context;", "providePassiveGoogleFusedManufactureManager", "Lorg/findmykids/geo/data/repository/trigger/passive/PassiveManager;", "providePassiveHuaweiFusedManufactureManager", "providePassiveLocationManagerAndroidManager", "provideStationManager", "Lorg/findmykids/geo/data/repository/trigger/station/StationManager;", "provideTimerAlarmManager", "Lorg/findmykids/geo/data/repository/trigger/timer/TimerManager;", "provideZonesManager", "Lorg/findmykids/geo/data/repository/trigger/zones/ZonesManager;", "geo_release"})
public final class DataTriggerModule {
    @Provides
    @SessionScope
    @NotNull
    public final ActivityManager provideActivityManager(@NotNull Context context) {
        ActivityManager activityManager;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (ManufactureUtil.INSTANCE.isHuawei() && ManufactureUtil.INSTANCE.isEmuiVersion9_1orAfter()) {
            ActivityManager activityManager2;
            try {
                if (ActivityIdentification.getService((Context)context) == null) {
                    Intrinsics.throwNpe();
                }
                activityManager2 = new ActivityHuaweiManagerImpl(context);
            }
            catch (Exception e) {
                activityManager2 = new ActivityGoogleManagerImpl(context);
            }
            activityManager = activityManager2;
        } else {
            activityManager = new ActivityGoogleManagerImpl(context);
        }
        return activityManager;
    }

    @Provides
    @SessionScope
    @Named(value="LocationManager")
    @NotNull
    public final PassiveManager providePassiveLocationManagerAndroidManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new PassiveLocationManagerManagerImpl(context);
    }

    @Provides
    @SessionScope
    @Named(value="GoogleFused")
    @NotNull
    public final PassiveManager providePassiveGoogleFusedManufactureManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new PassiveGoogleFusedManagerImpl(context);
    }

    @Provides
    @SessionScope
    @Named(value="HuaweiFused")
    @NotNull
    public final PassiveManager providePassiveHuaweiFusedManufactureManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new PassiveHuaweiFusedManagerImpl(context);
    }

    @Provides
    @SessionScope
    @NotNull
    public final StationManager provideStationManager(@NotNull Context context) {
        StationManager stationManager;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (ManufactureUtil.INSTANCE.isHuawei() && ManufactureUtil.INSTANCE.isEmuiVersion10orAfter()) {
            StationManager stationManager2;
            try {
                if (LocationServices.getGeofenceService((Context)context) == null) {
                    Intrinsics.throwNpe();
                }
                stationManager2 = new StationHuaweiManagerImpl(context);
            }
            catch (Exception e) {
                stationManager2 = new StationGoogleManagerImpl(context);
            }
            stationManager = stationManager2;
        } else {
            stationManager = new StationGoogleManagerImpl(context);
        }
        return stationManager;
    }

    @Provides
    @SessionScope
    @NotNull
    public final TimerManager provideTimerAlarmManager(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new TimerAlarmManagerImpl(context);
    }

    @Provides
    @SessionScope
    @NotNull
    public final ZonesManager provideZonesManager(@NotNull Context context) {
        ZonesManager zonesManager;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (ManufactureUtil.INSTANCE.isHuawei() && ManufactureUtil.INSTANCE.isEmuiVersion10orAfter()) {
            ZonesManager zonesManager2;
            try {
                if (LocationServices.getGeofenceService((Context)context) == null) {
                    Intrinsics.throwNpe();
                }
                zonesManager2 = new ZonesHuaweiManagerImpl(context);
            }
            catch (Exception e) {
                zonesManager2 = new ZonesGoogleManagerImpl(context);
            }
            zonesManager = zonesManager2;
        } else {
            zonesManager = new ZonesGoogleManagerImpl(context);
        }
        return zonesManager;
    }

    public DataTriggerModule() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
    }
}

