/*
 * Decompiled with CFR 0.152.
 */
package org.findmykids.geo.common.di.session.module;

import dagger.Module;
import dagger.Provides;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.findmykids.geo.api.extensions.GeoExtensions;
import org.findmykids.geo.common.di.session.SessionScope;
import org.findmykids.geo.common.di.session.module.DBModule;
import org.findmykids.geo.common.di.session.module.NetworkModule;
import org.findmykids.geo.common.logger.Logger;
import org.findmykids.geo.data.db.GeoDatabase;
import org.findmykids.geo.data.network.SocketClient;
import org.findmykids.geo.data.network.YandexApi;
import org.findmykids.geo.data.preferences.LocalPreferences;
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepository;
import org.findmykids.geo.data.repository.storage.configuration.ConfigurationRepositoryImpl;
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepository;
import org.findmykids.geo.data.repository.storage.currentSession.CurrentSessionRepositoryImpl;
import org.findmykids.geo.data.repository.storage.error.ErrorRepository;
import org.findmykids.geo.data.repository.storage.error.ErrorRepositoryImpl;
import org.findmykids.geo.data.repository.storage.geo.GeoRepository;
import org.findmykids.geo.data.repository.storage.geo.GeoRepositoryImpl;
import org.findmykids.geo.data.repository.storage.request.RequestRepository;
import org.findmykids.geo.data.repository.storage.request.RequestRepositoryImpl;
import org.findmykids.geo.data.repository.storage.yandexLocator.YandexLocatorRepository;
import org.findmykids.geo.data.repository.storage.yandexLocator.YandexLocatorRepositoryImpl;
import org.findmykids.geo.data.repository.storage.zones.ZonesRepository;
import org.findmykids.geo.data.repository.storage.zones.ZonesRepositoryImpl;
import org.jetbrains.annotations.NotNull;

@Module(includes={DBModule.class, NetworkModule.class})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u001b"}, d2={"Lorg/findmykids/geo/common/di/session/module/DataStorageModule;", "", "()V", "provideConfigurationRepository", "Lorg/findmykids/geo/data/repository/storage/configuration/ConfigurationRepository;", "geoDatabase", "Lorg/findmykids/geo/data/db/GeoDatabase;", "provideCurrentSessionRepository", "Lorg/findmykids/geo/data/repository/storage/currentSession/CurrentSessionRepository;", "localPreferences", "Lorg/findmykids/geo/data/preferences/LocalPreferences;", "provideErrorRepository", "Lorg/findmykids/geo/data/repository/storage/error/ErrorRepository;", "socketClient", "Lorg/findmykids/geo/data/network/SocketClient;", "provideGeoRepository", "Lorg/findmykids/geo/data/repository/storage/geo/GeoRepository;", "geoExtensions", "Lorg/findmykids/geo/api/extensions/GeoExtensions;", "provideRequestRepository", "Lorg/findmykids/geo/data/repository/storage/request/RequestRepository;", "provideYandexLocatorRepository", "Lorg/findmykids/geo/data/repository/storage/yandexLocator/YandexLocatorRepository;", "yandexApi", "Lorg/findmykids/geo/data/network/YandexApi;", "provideZonesRepository", "Lorg/findmykids/geo/data/repository/storage/zones/ZonesRepository;", "geo_release"})
public final class DataStorageModule {
    @Provides
    @SessionScope
    @NotNull
    public final CurrentSessionRepository provideCurrentSessionRepository(@NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new CurrentSessionRepositoryImpl(localPreferences);
    }

    @Provides
    @SessionScope
    @NotNull
    public final GeoRepository provideGeoRepository(@NotNull SocketClient socketClient, @NotNull GeoDatabase geoDatabase, @NotNull GeoExtensions geoExtensions, @NotNull LocalPreferences localPreferences) {
        Intrinsics.checkParameterIsNotNull((Object)socketClient, (String)"socketClient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)geoDatabase), (String)"geoDatabase");
        Intrinsics.checkParameterIsNotNull((Object)geoExtensions, (String)"geoExtensions");
        Intrinsics.checkParameterIsNotNull((Object)localPreferences, (String)"localPreferences");
        return new GeoRepositoryImpl(socketClient, geoDatabase, geoExtensions, localPreferences);
    }

    @Provides
    @SessionScope
    @NotNull
    public final ErrorRepository provideErrorRepository(@NotNull SocketClient socketClient, @NotNull GeoDatabase geoDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)socketClient, (String)"socketClient");
        Intrinsics.checkParameterIsNotNull((Object)((Object)geoDatabase), (String)"geoDatabase");
        return new ErrorRepositoryImpl(socketClient, geoDatabase);
    }

    @Provides
    @SessionScope
    @NotNull
    public final RequestRepository provideRequestRepository(@NotNull SocketClient socketClient) {
        Intrinsics.checkParameterIsNotNull((Object)socketClient, (String)"socketClient");
        return new RequestRepositoryImpl(socketClient);
    }

    @Provides
    @SessionScope
    @NotNull
    public final ConfigurationRepository provideConfigurationRepository(@NotNull GeoDatabase geoDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)geoDatabase), (String)"geoDatabase");
        return new ConfigurationRepositoryImpl(geoDatabase);
    }

    @Provides
    @SessionScope
    @NotNull
    public final YandexLocatorRepository provideYandexLocatorRepository(@NotNull YandexApi yandexApi) {
        Intrinsics.checkParameterIsNotNull((Object)yandexApi, (String)"yandexApi");
        return new YandexLocatorRepositoryImpl(yandexApi);
    }

    @Provides
    @SessionScope
    @NotNull
    public final ZonesRepository provideZonesRepository(@NotNull GeoDatabase geoDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)geoDatabase), (String)"geoDatabase");
        return new ZonesRepositoryImpl(geoDatabase);
    }

    public DataStorageModule() {
        Logger.d$default(Logger.INSTANCE, null, 1, null).print();
    }
}

