package org.findmykids.geo.domain.model

import org.findmykids.geo.data.model.ActivityEvent
import org.findmykids.geo.data.model.StationEvent
import org.findmykids.geo.data.model.ZoneEvent
import org.findmykids.geo.data.model.CommandType
import org.findmykids.geo.data.model.Location
import java.util.*


/**
 * Команды которые обрабатываются в сессии
 */
sealed class Command(
    val type: CommandType,
    val isMain: Boolean,
    val create: Date = Date()
) {
    /**
     * Активация
     */
    class Activate(
        val baseUrl: String,
        val apiKey: CharArray,
        val userToken: CharArray,
        val userId: CharArray
    ) : Command(CommandType.ACTIVATE, true) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[1].name}=$baseUrl, " +
//                    "${this::class.java.declaredFields[0].name}=$apiKey, " +
//                    "${this::class.java.declaredFields[3].name}=$userToken, " +
                    "${this::class.java.declaredFields[2].name}=$userId)"
        }
    }

    /**
     * Деактивация
     */
    class Deactivate : Command(CommandType.DEACTIVATE, true) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create)"
        }
    }

    /**
     *  Приложение пингануло сервис, по какой либо причине
     */
    class Ping : Command(CommandType.PING, true) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create)"
        }
    }

    /**
     * Приложение запросило последнюю координату
     */
    class Request : Command(CommandType.REQUEST, true) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create)"
        }
    }

    /**
     * Сработал таймер
     */
    class Timer : Command(CommandType.TIMER, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create)"
        }
    }

    /**
     * Телефон включился
     */
    class Boot : Command(CommandType.BOOT, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create)"
        }
    }

    /**
     * Изменился тип движения
     */
    class Activity(
        private val activityEvent: ActivityEvent
    ) : Command(CommandType.ACTIVITY, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$activityEvent)"
        }
    }

    /**
     * Сработала зона безопасности (не используется)
     */
    // TODO Зоны безопасности
    class Zone(
        private val zoneEvent: ZoneEvent
    ) : Command(CommandType.ZONE, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$zoneEvent)"
        }
    }

    /**
     * Вышел за приделы зоны относительно последнее локации своего местоположения
     */
    class Station(
        private val stationEvent: StationEvent
    ) : Command(CommandType.STATION, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$stationEvent)"
        }
    }

    /**
     * Пассивное изменние геолокации
     */
    class Passive(
        val location: Location
    ) : Command(CommandType.PASSIVE, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$location)"
        }
    }

    /**
     * Установить значение реалтайма
     */
    class Realtime(val enable: Boolean) : Command(CommandType.REALTIME, true) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$enable)"
        }
    }

    /**
     * Какая то ошибка в определении команды
     */
    class Invalid(val throwable: Throwable) : Command(CommandType.INVALID, false) {
        override fun toString(): String {
            return "${this::class.simpleName}(" +
                    "${this::class.java.superclass!!.declaredFields[0].name}=$create, " +
                    "${this::class.java.declaredFields[0].name}=$throwable)"
        }
    }


    override fun toString(): String = ""
}