package org.findmykids.geo.data.repository.trigger.zones.google

import android.annotation.SuppressLint
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import com.google.android.gms.location.Geofence
import com.google.android.gms.location.GeofencingRequest
import com.google.android.gms.location.LocationServices
import com.google.android.gms.tasks.Tasks
import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Zones
import org.findmykids.geo.data.repository.trigger.zones.ZonesManager
import java.util.concurrent.TimeUnit
import javax.inject.Inject


// TODO Зоны безопасности
internal class ZonesGoogleManagerImpl @Inject constructor(
    private val mContext: Context
) : ZonesManager {

    override fun toString(): String = ""

    override fun isSubscribed(): Single<Boolean> = Single
        .fromCallable {
            Logger.d().with(this@ZonesGoogleManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE) != null
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesGoogleManagerImpl).print()
        }

    @SuppressLint("MissingPermission")
    override fun subscribe(zones: Zones): Completable = Single
        .fromCallable {
            Logger.d().with(this@ZonesGoogleManagerImpl).print()
            if (zones.zones.isNotEmpty()) {
                Logger.d("has zones").with(this@ZonesGoogleManagerImpl).print()
                getIntent(PendingIntent.FLAG_UPDATE_CURRENT)?.let { intent ->
                    Logger.d("has intent").with(this@ZonesGoogleManagerImpl).print()
                    val geofencingRequest = GeofencingRequest.Builder()
                        .setInitialTrigger(GeofencingRequest.INITIAL_TRIGGER_ENTER or GeofencingRequest.INITIAL_TRIGGER_EXIT)
                        .addGeofences(zones.zones.map {
                            Geofence.Builder()
                                .setTransitionTypes(Geofence.GEOFENCE_TRANSITION_ENTER or Geofence.GEOFENCE_TRANSITION_EXIT)
                                .setCircularRegion(it.lat, it.lon, it.radius)
                                .setRequestId(it.id)
                                .setExpirationDuration(Geofence.NEVER_EXPIRE)
                                .build()
                        })
                        .build()
                    try {
                        Tasks.await(LocationServices.getGeofencingClient(mContext).addGeofences(geofencingRequest, intent), 10, TimeUnit.SECONDS)
                        true
                    } catch (e: Exception) {
                        Logger.e(GeoException.ZoneSubscription(e)).with(this@ZonesGoogleManagerImpl).print()
                        false
                    }
                } ?: false
            } else {
                false
            }
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesGoogleManagerImpl).print()
        }
        .ignoreElement()

    override fun unsubscribe(): Completable = Single
        .fromCallable {
            Logger.d().with(this@ZonesGoogleManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE)?.let { intent ->
                Logger.d("has intent").with(this@ZonesGoogleManagerImpl).print()
                try {
                    Tasks.await(LocationServices.getGeofencingClient(mContext).removeGeofences(intent), 10, TimeUnit.SECONDS)
                    true
                } catch (e: Exception) {
                    Logger.e(GeoException.ZoneUnSubscription(e)).with(this@ZonesGoogleManagerImpl).print()
                    false
                } finally {
                    intent.cancel()
                }
            } ?: true
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ZonesGoogleManagerImpl).print()
        }
        .ignoreElement()


    private fun getIntent(flags: Int): PendingIntent? {
        Logger.d().print()
        val intent = Intent(mContext, ZonesGoogleReceiver::class.java)
        intent.addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)
        return PendingIntent.getBroadcast(mContext, REQUEST_ZONES_GOOGLE, intent, flags)
    }


    companion object {
        private const val REQUEST_ZONES_GOOGLE = 6748609
    }
}