package org.findmykids.geo.data.repository.trigger.station

import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.BroadcastReceiver
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.PersistableBundle
import androidx.core.content.ContextCompat.getSystemService
import com.google.gson.Gson
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.StationEvent
import org.findmykids.geo.presentation.session.SessionService
import java.util.concurrent.TimeUnit


internal abstract class BaseStationReceiver : BroadcastReceiver() {
    fun send(context: Context, stationEvent: StationEvent) {
        val textStationEvent = Gson().toJson(stationEvent)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val extras = PersistableBundle().apply {
                putString(EXTRA_STATION_EVENT, textStationEvent)
            }
            val jobInfo = JobInfo
                .Builder(StationJobSchedulerService.JOB_ID, ComponentName(context, StationJobSchedulerService::class.java))
                .setOverrideDeadline(TimeUnit.SECONDS.toMillis(5))
                .setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY)
                .setExtras(extras)
                .build()
            val jobScheduler = getSystemService(context, JobScheduler::class.java)
            jobScheduler?.let {
                Logger.d("job scheduled").with(this@BaseStationReceiver).print()
                it.schedule(jobInfo)
            }
        } else {
            val actionIntent = Intent(context, SessionService::class.java)
            actionIntent.action = ACTION_STATION
            actionIntent.putExtra(EXTRA_STATION_EVENT, textStationEvent)
            context.startService(actionIntent)
        }
    }


    companion object {
        const val ACTION_STATION = "ACTION_STATION"
        const val EXTRA_STATION_EVENT = "EXTRA_STATION_EVENT"
    }
}