package org.findmykids.geo.data.repository.trigger.passive

import android.app.job.JobInfo
import android.app.job.JobScheduler
import android.content.BroadcastReceiver
import android.content.ComponentName
import android.content.Context
import android.content.Intent
import android.os.Build
import android.os.PersistableBundle
import androidx.core.content.ContextCompat.getSystemService
import com.google.gson.Gson
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Location
import org.findmykids.geo.presentation.session.SessionService
import java.util.concurrent.TimeUnit


internal abstract class BasePassiveReceiver : BroadcastReceiver() {
    fun send(context: Context, location: Location) {
        val textLocation = Gson().toJson(location)
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val extras = PersistableBundle().apply {
                putString(EXTRA_LOCATION, textLocation)
            }
            val jobInfo = JobInfo
                .Builder(
                    PassiveJobSchedulerService.JOB_ID,
                    ComponentName(context, PassiveJobSchedulerService::class.java)
                )
                .setOverrideDeadline(TimeUnit.SECONDS.toMillis(5))
                .setRequiredNetworkType(JobInfo.NETWORK_TYPE_ANY)
                .setExtras(extras)
                .build()
            val jobScheduler = getSystemService(context, JobScheduler::class.java)
            jobScheduler?.let {
                Logger.d("job scheduled").with(this@BasePassiveReceiver).print()
                it.schedule(jobInfo)
            }
        } else {
            val actionIntent = Intent(context, SessionService::class.java)
            actionIntent.action = ACTION_PASSIVE
            actionIntent.putExtra(EXTRA_LOCATION, textLocation)
            context.startService(actionIntent)
        }
    }


    companion object {
        const val ACTION_PASSIVE = "ACTION_PASSIVE"
        const val EXTRA_LOCATION = "EXTRA_LOCATION"
    }
}