package org.findmykids.geo.data.repository.trigger.activity.huawei

import android.Manifest.permission.ACTIVITY_RECOGNITION
import android.app.PendingIntent
import android.content.Context
import android.content.Intent
import android.content.pm.PackageManager.PERMISSION_GRANTED
import android.os.Build
import com.huawei.hmf.tasks.Tasks
import com.huawei.hms.location.ActivityConversionInfo
import com.huawei.hms.location.ActivityConversionRequest
import com.huawei.hms.location.ActivityIdentification
import io.reactivex.Completable
import io.reactivex.Single
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.common.logger.Logger
import org.findmykids.geo.data.model.Configuration
import org.findmykids.geo.data.repository.trigger.activity.ActivityManager
import java.util.concurrent.TimeUnit
import javax.inject.Inject


internal class ActivityHuaweiManagerImpl @Inject constructor(
    private val mContext: Context
) : ActivityManager {

    override fun toString(): String = ""

    override fun isSubscribed(): Single<Boolean> = Single
        .fromCallable {
            Logger.d().with(this@ActivityHuaweiManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE) != null
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ActivityHuaweiManagerImpl).print()
        }

    override fun subscribe(activityConfiguration: Configuration.ActivityConfiguration): Completable = Single
        .fromCallable {
            Logger.d().with(this@ActivityHuaweiManagerImpl).print()
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q &&
                mContext.checkSelfPermission(ACTIVITY_RECOGNITION) != PERMISSION_GRANTED
            ) {
                Logger.e(GeoException.ActivityTransitionNoPermission(ACTIVITY_RECOGNITION)).with(this@ActivityHuaweiManagerImpl).print()
                false
            } else {
                getIntent(PendingIntent.FLAG_UPDATE_CURRENT)?.let { intent ->
                    Logger.d("has intent").with(this@ActivityHuaweiManagerImpl).print()
                    val transitions = mutableListOf<ActivityConversionInfo>()
                    for (activity in activityConfiguration.activities) {
                        transitions.add(
                            ActivityConversionInfo.Builder().setActivityType(activity + 100).setConversionType(
                                ActivityConversionInfo.ENTER_ACTIVITY_CONVERSION
                            ).build()
                        )
                        transitions.add(
                            ActivityConversionInfo.Builder().setActivityType(activity + 100).setConversionType(
                                ActivityConversionInfo.EXIT_ACTIVITY_CONVERSION
                            ).build()
                        )
                    }
                    try {
                        Tasks.await(
                            ActivityIdentification.getService(mContext).createActivityConversionUpdates(
                                ActivityConversionRequest(transitions),
                                intent
                            ), 10, TimeUnit.SECONDS
                        )
                        true
                    } catch (e: Exception) {
                        Logger.e(GeoException.ActivityTransitionSubscription(e)).with(this@ActivityHuaweiManagerImpl).print()
                        false
                    }
                } ?: false
            }
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ActivityHuaweiManagerImpl).print()
        }
        .ignoreElement()

    override fun unsubscribe(): Completable = Single
        .fromCallable {
            Logger.d().with(this@ActivityHuaweiManagerImpl).print()
            getIntent(PendingIntent.FLAG_NO_CREATE)?.let { intent ->
                Logger.d("has intent").with(this@ActivityHuaweiManagerImpl).print()
                try {
                    Tasks.await(ActivityIdentification.getService(mContext).deleteActivityConversionUpdates(intent), 10, TimeUnit.SECONDS)
                    true
                } catch (e: Exception) {
                    Logger.e(GeoException.ActivityTransitionUnSubscription(e)).with(this@ActivityHuaweiManagerImpl).print()
                    false
                } finally {
                    intent.cancel()
                }
            } ?: true
        }
        .doOnSuccess {
            Logger.i().setResult(it).with(this@ActivityHuaweiManagerImpl).print()
        }
        .ignoreElement()


    private fun getIntent(flags: Int): PendingIntent? {
        Logger.d().print()
        val intent = Intent(mContext, ActivityHuaweiReceiver::class.java)
        intent.addFlags(Intent.FLAG_INCLUDE_STOPPED_PACKAGES)
        return PendingIntent.getBroadcast(mContext, REQUEST_ACTIVITY_HUAWEI, intent, flags)
    }


    companion object {
        private const val REQUEST_ACTIVITY_HUAWEI = 6748602
    }
}