package org.findmykids.geo.data.repository.live.remote

import geocoreproto.ConfigAndroid
import geocoreproto.SafeZones
import org.findmykids.geo.common.GeoException
import org.findmykids.geo.data.network.model.SocketCommand
import org.findmykids.geo.data.network.model.SocketData


internal object RemoteEventFactory {
    fun createSocketEvent(socketData: SocketData): RemoteEvent =
        when (socketData.commandId) {
            SocketCommand.START -> RemoteEvent.Created
            SocketCommand.STOP -> RemoteEvent.Deactivate
            SocketCommand.UPDATE_CONFIGURATION -> RemoteEvent.ConfigurationsChanged(
                ConfigurationsFactory.createConfigurations(ConfigAndroid.parseFrom(socketData.payload!!))
            )
            SocketCommand.UPDATE_SAFE_ZONE -> RemoteEvent.ZoneChanged(ZonesFactory.createZones(SafeZones.parseFrom(socketData.payload!!)))
            SocketCommand.SET_COORDS -> throw GeoException.InvalidSocketEvent(socketData.commandId)
            SocketCommand.LIVE_ON -> RemoteEvent.RealtimeBegin
            SocketCommand.LIVE_OFF -> RemoteEvent.RealtimeEnd
            SocketCommand.GET_GEO -> RemoteEvent.Request
            SocketCommand.GET_RETRY -> RemoteEvent.ReRequest
            SocketCommand.COORD_NOT_CHANGED -> throw GeoException.InvalidSocketEvent(socketData.commandId)
            SocketCommand.COORD_EMPTY -> throw GeoException.InvalidSocketEvent(socketData.commandId)
            SocketCommand.CHILD_CLOSED_CONNECTION -> throw GeoException.InvalidSocketEvent(socketData.commandId)
            SocketCommand.CHILD_ESTABLISHED_CONNECTION -> throw GeoException.InvalidSocketEvent(socketData.commandId)
        }
}