package org.findmykids.geo.data.model

import androidx.annotation.IntDef
import com.google.android.gms.location.DetectedActivity


enum class ActivityType(@DetectedActivityType detectedActivityType: Int) {
    IN_VEHICLE(DetectedActivity.IN_VEHICLE),
    ON_BICYCLE(DetectedActivity.ON_BICYCLE),
    ON_FOOT(DetectedActivity.ON_FOOT),
    STILL(DetectedActivity.STILL),
    UNKNOWN(DetectedActivity.UNKNOWN),
    TILTING(DetectedActivity.TILTING),
    WALKING(DetectedActivity.WALKING),
    RUNNING(DetectedActivity.RUNNING);


    companion object {
        @IntDef(
            DetectedActivity.IN_VEHICLE,
            DetectedActivity.ON_BICYCLE,
            DetectedActivity.ON_FOOT,
            DetectedActivity.STILL,
            DetectedActivity.UNKNOWN,
            DetectedActivity.TILTING,
            DetectedActivity.WALKING,
            DetectedActivity.RUNNING
        )
        @Retention(AnnotationRetention.SOURCE)
        annotation class DetectedActivityType


        fun toActivityType(@DetectedActivityType detectedActivityType: Int) = when (detectedActivityType) {
            DetectedActivity.IN_VEHICLE -> IN_VEHICLE
            DetectedActivity.ON_BICYCLE -> ON_BICYCLE
            DetectedActivity.ON_FOOT -> ON_FOOT
            DetectedActivity.STILL -> STILL
            DetectedActivity.UNKNOWN -> UNKNOWN
            DetectedActivity.TILTING -> TILTING
            DetectedActivity.WALKING -> WALKING
            DetectedActivity.RUNNING -> RUNNING
            else -> UNKNOWN
        }
    }
}