package org.findmykids.geo.data.db.model

import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverters
import org.findmykids.geo.data.db.converter.ActivityTypesWithConfidencesMapConverter
import org.findmykids.geo.data.db.converter.DateConverter
import org.findmykids.geo.data.db.converter.SessionCommandsTypesListConverter
import org.findmykids.geo.data.model.ActivityType
import org.findmykids.geo.data.model.CommandType
import java.util.*


@Entity
@TypeConverters(
    DateConverter::class,
    SessionCommandsTypesListConverter::class,
    ActivityTypesWithConfidencesMapConverter::class
)
internal data class ErrorEntity(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,

    val create: Date,

    val sessionIndex: Long,
    val sessionCreate: Date,
    val sessionIsRealtime: Boolean,
    val sessionCommandsTypes: List<CommandType>,

    val activityExist: Boolean,
    val activityElapsedRealtimeMillis: Long?,
    val activityTime: Long?,
    val activityActivitiesWithConfidences: Map<ActivityType, Int>?,

    val batteryExist: Boolean,
    val batteryIsCharging: Boolean?,
    val batteryLevel: Int?,

    val text: String
) {
    override fun toString(): String = ""
}