package org.findmykids.geo.data.db.dao

import androidx.room.*
import org.findmykids.geo.data.db.model.GeoEntity


@Dao
internal interface GeosDao {
    @Query("SELECT * FROM GeoEntity LIMIT :limit")
    fun select(limit: Int): List<GeoEntity>

    @Insert(onConflict = OnConflictStrategy.ABORT)
    fun insert(geoEntity: GeoEntity)

    @Delete
    fun delete(geoEntity: GeoEntity)

    @Query("DELETE FROM GeoEntity")
    fun deleteAll()
}