package org.findmykids.geo.data.db.converter

import androidx.room.TypeConverter
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import org.findmykids.geo.data.model.ActivityType


internal class ActivityTypesWithConfidencesMapConverter {
    @TypeConverter
    fun to(list: String?): Map<ActivityType, Int>? {
        return if (list == null) {
            null
        } else {
            Gson().fromJson(list, object : TypeToken<Map<ActivityType, Int>?>() {}.type)
        }
    }

    @TypeConverter
    fun from(list: Map<ActivityType, Int>?): String? {
        return if (list == null) {
            null
        } else {
            Gson().toJson(list, object : TypeToken<Map<ActivityType, Int>?>() {}.type)
        }
    }
}