package org.findmykids.geo.common.utils

import android.location.LocationManager


internal object LocationManagerUtil {
    fun isEnabled(locationManager: LocationManager?): Boolean {
        if (locationManager == null) {
            return false
        }
        val gpsEnabled = try {
            locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)
        } catch (e: Exception) {
            false
        }
        val networkEnabled = try {
            locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER)
        } catch (e: Exception) {
            false
        }
        return gpsEnabled || networkEnabled
    }

    fun isGpsEnabled(locationManager: LocationManager?): Boolean {
        if (locationManager == null) {
            return false
        }
        return try {
            locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)
        } catch (e: Exception) {
            false
        }
    }
}