package org.findmykids.geo.common.logger

import androidx.room.Entity
import androidx.room.PrimaryKey
import androidx.room.TypeConverters
import org.findmykids.geo.data.db.converter.DateConverter


@Entity
@TypeConverters(DateConverter::class)
internal data class LogEntity(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val pid: Long,
    val date: String,
    val version: String,
    val type: String,
    val className: String,
    val methodName: String,
    val text: String
) {
    override fun toString(): String = ""
}